/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.cassandra;

import java.util.HashMap;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.store.cassandra.CassandraStorageConfig;
import org.apache.drill.exec.store.cassandra.TestCassandraSuite;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.testcontainers.containers.CassandraContainer;

public class BaseCassandraTest
extends ClusterTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestCassandraSuite.initCassandra();
        BaseCassandraTest.initCassandraPlugin(TestCassandraSuite.cassandra);
    }

    private static void initCassandraPlugin(CassandraContainer<?> cassandra) throws Exception {
        ClusterFixtureBuilder builder = new ClusterFixtureBuilder(dirTestWatcher).configProperty("drill.exec.http.enabled", (Object)true).configProperty("drill.exec.http.porthunt", (Object)true).configProperty("drill.exec.impersonation.enabled", (Object)true);
        BaseCassandraTest.startCluster((ClusterFixtureBuilder)builder);
        CassandraStorageConfig config = new CassandraStorageConfig(cassandra.getHost(), cassandra.getMappedPort(CassandraContainer.CQL_PORT.intValue()).intValue(), cassandra.getUsername(), cassandra.getPassword(), StoragePluginConfig.AuthMode.SHARED_USER.name(), null);
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("cassandra", (StoragePluginConfig)config);
        PlainCredentialsProvider credentialsProvider = new PlainCredentialsProvider(new HashMap());
        credentialsProvider.setUserCredentials(cassandra.getUsername(), cassandra.getPassword(), "testUser1");
        credentialsProvider.setUserCredentials("nope", "no way dude", "testUser2");
        CassandraStorageConfig ut_config = new CassandraStorageConfig(cassandra.getHost(), cassandra.getMappedPort(CassandraContainer.CQL_PORT.intValue()).intValue(), null, null, StoragePluginConfig.AuthMode.USER_TRANSLATION.name(), (CredentialsProvider)credentialsProvider);
        ut_config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("ut_cassandra", (StoragePluginConfig)ut_config);
    }

    @AfterClass
    public static void tearDownCassandra() {
        if (TestCassandraSuite.isRunningSuite()) {
            TestCassandraSuite.tearDownCluster();
        }
    }
}

