/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.cassandra.CassandraRel;
import org.apache.calcite.adapter.cassandra.CassandraRules;
import org.apache.calcite.adapter.cassandra.CassandraTable;
import org.apache.calcite.adapter.cassandra.CassandraTableScan;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.exec.store.cassandra.plan.CassandraEnumerablePrelContext;
import org.apache.drill.exec.store.cassandra.plan.DrillCassandraLimitRule;
import org.apache.drill.exec.store.cassandra.schema.CassandraDrillSchema;
import org.apache.drill.exec.store.enumerable.plan.EnumerableIntermediatePrelConverterRule;
import org.apache.drill.exec.store.enumerable.plan.EnumerablePrelContext;
import org.apache.drill.exec.store.enumerable.plan.VertexDrelConverterRule;

public class CalciteUtils {
    private static final RelOptRule VERTEX_DREL_CONVERTER_RULE = VertexDrelConverterRule.create((Convention)CassandraRel.CONVENTION);
    private static final RelOptRule ENUMERABLE_INTERMEDIATE_PREL_CONVERTER_RULE = new EnumerableIntermediatePrelConverterRule((EnumerablePrelContext)new CassandraEnumerablePrelContext("cassandra"), CassandraRel.CONVENTION);

    public static CassandraTableScan tableScanCreator(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, CassandraTable cassandraTable, RelDataType projectRowType) {
        return new CassandraTableScan(cluster, traitSet, table, cassandraTable, projectRowType);
    }

    public static Set<RelOptRule> cassandraRules() {
        Set<RelOptRule> rules = Arrays.stream(CassandraRules.RULES).collect(Collectors.toSet());
        rules.add((RelOptRule)DrillCassandraLimitRule.INSTANCE);
        rules.add(ENUMERABLE_INTERMEDIATE_PREL_CONVERTER_RULE);
        rules.add(VERTEX_DREL_CONVERTER_RULE);
        return rules;
    }

    public static CqlSession getSession(SchemaPlus schema) {
        return ((CassandraDrillSchema)((Object)schema.unwrap(CassandraDrillSchema.class))).getDelegatingSchema().session;
    }
}

