/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.cassandra.schema;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.cassandra.CassandraSchema;
import org.apache.calcite.adapter.cassandra.CassandraTable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.cassandra.schema.CassandraDynamicTable;

public class CassandraDrillSchema
extends AbstractSchema {
    private final CassandraSchema delegatingSchema;
    private final StoragePlugin plugin;
    private final Map<String, Table> tables = new ConcurrentHashMap<String, Table>();

    public CassandraDrillSchema(String name, StoragePlugin plugin, CassandraSchema delegatingSchema) {
        super(Collections.emptyList(), name);
        this.plugin = plugin;
        this.delegatingSchema = delegatingSchema;
    }

    public String getTypeName() {
        return "cassandra";
    }

    public Table getTable(String tableName) {
        return this.tables.computeIfAbsent(tableName, this::getDrillTable);
    }

    private DrillTable getDrillTable(String tableName) {
        CassandraTable table = (CassandraTable)this.delegatingSchema.getTable(tableName);
        return table == null ? null : new CassandraDynamicTable(this.plugin, tableName, null, table);
    }

    public Set<String> getTableNames() {
        return this.delegatingSchema.getTableNames();
    }

    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, (Expression[])new Expression[0]);
    }

    public CassandraSchema getDelegatingSchema() {
        return this.delegatingSchema;
    }
}

