/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.cassandra;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.cassandra.CassandraComplexTypesTest;
import org.apache.drill.exec.store.cassandra.CassandraPlanTest;
import org.apache.drill.exec.store.cassandra.CassandraQueryTest;
import org.apache.drill.test.BaseTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.testcontainers.containers.CassandraContainer;

@Category(value={SlowTest.class})
@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={CassandraComplexTypesTest.class, CassandraPlanTest.class, CassandraQueryTest.class})
public class TestCassandraSuite
extends BaseTest {
    protected static CassandraContainer<?> cassandra;
    private static final AtomicInteger initCount;
    private static volatile boolean runningSuite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void initCassandra() {
        Class<TestCassandraSuite> clazz = TestCassandraSuite.class;
        synchronized (TestCassandraSuite.class) {
            if (initCount.get() == 0) {
                TestCassandraSuite.startCassandra();
            }
            initCount.incrementAndGet();
            runningSuite = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isRunningSuite() {
        return runningSuite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownCluster() {
        Class<TestCassandraSuite> clazz = TestCassandraSuite.class;
        synchronized (TestCassandraSuite.class) {
            if (initCount.decrementAndGet() == 0 && cassandra != null) {
                cassandra.stop();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void startCassandra() {
        cassandra = (CassandraContainer)((CassandraContainer)((CassandraContainer)new CassandraContainer("cassandra").withInitScript("queries.cql").withStartupTimeout(Duration.ofMinutes(2L))).withEnv("CASSANDRA_SNITCH", "GossipingPropertyFileSnitch")).withEnv("JVM_OPTS", "-Dcassandra.skip_wait_for_gossip_to_settle=0 -Dcassandra.initial_token=0");
        cassandra.start();
    }

    static {
        initCount = new AtomicInteger(0);
        runningSuite = false;
    }
}

