/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.cassandra;

import org.apache.drill.exec.store.cassandra.BaseCassandraTest;
import org.junit.Test;

public class CassandraPlanTest
extends BaseCassandraTest {
    @Test
    public void testProjectPushDown() throws Exception {
        this.queryBuilder().sql("select n_name, n_nationkey from cassandra.test_keyspace.`nation`").planMatcher().include(new String[]{"cassandra=.*n_name.*n_nationkey"}).exclude(new String[]{"\\*\\*"}).match();
    }

    @Test
    public void testFilterPushDown() throws Exception {
        this.queryBuilder().sql("select n_name, n_nationkey from cassandra.test_keyspace.`nation` where n_nationkey = 0").planMatcher().include(new String[]{"CassandraFilter"}).match();
    }

    @Test
    public void testFilterPushDownWithJoin() throws Exception {
        String query = "select * from cassandra.test_keyspace.`nation` e\njoin cassandra.test_keyspace.`nation` s on e.n_name = s.n_name where e.n_nationkey = 'algeria'";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"CassandraFilter"}).match();
    }

    @Test
    public void testLimitPushDown() throws Exception {
        this.queryBuilder().sql("select n_nationkey from cassandra.test_keyspace.`nation` limit 3").planMatcher().include(new String[]{"CassandraLimit.*fetch"}).match();
    }
}

