/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.cassandra;

import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.cassandra.CassandraStorageConfig;
import org.apache.drill.exec.store.cassandra.TestCassandraSuite;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.testcontainers.containers.CassandraContainer;

public class BaseCassandraTest
extends ClusterTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestCassandraSuite.initCassandra();
        BaseCassandraTest.initCassandraPlugin(TestCassandraSuite.cassandra);
    }

    private static void initCassandraPlugin(CassandraContainer<?> cassandra) throws Exception {
        BaseCassandraTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        CassandraStorageConfig config = new CassandraStorageConfig(cassandra.getHost(), cassandra.getMappedPort(CassandraContainer.CQL_PORT.intValue()).intValue(), cassandra.getUsername(), cassandra.getPassword(), null);
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("cassandra", (StoragePluginConfig)config);
    }

    @AfterClass
    public static void tearDownCassandra() {
        if (TestCassandraSuite.isRunningSuite()) {
            TestCassandraSuite.tearDownCluster();
        }
    }
}

