/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.openTSDB.OpenTSDBGroupScan;
import org.apache.drill.exec.store.openTSDB.OpenTSDBScanSpec;
import org.apache.drill.exec.store.openTSDB.OpenTSDBStoragePluginConfig;
import org.apache.drill.exec.store.openTSDB.client.services.ServiceImpl;
import org.apache.drill.exec.store.openTSDB.schema.OpenTSDBSchemaFactory;

public class OpenTSDBStoragePlugin
extends AbstractStoragePlugin {
    private final OpenTSDBStoragePluginConfig engineConfig;
    private final OpenTSDBSchemaFactory schemaFactory = new OpenTSDBSchemaFactory(this, this.getName());
    private final ServiceImpl db;

    public OpenTSDBStoragePlugin(OpenTSDBStoragePluginConfig configuration, DrillbitContext context, String name) throws IOException {
        super(context, name);
        this.engineConfig = configuration;
        this.db = new ServiceImpl(configuration.getConnection());
    }

    public boolean supportsRead() {
        return true;
    }

    public OpenTSDBStoragePluginConfig getConfig() {
        return this.engineConfig;
    }

    public OpenTSDBGroupScan getPhysicalScan(String userName, JSONOptions selection) throws IOException {
        OpenTSDBScanSpec scanSpec = (OpenTSDBScanSpec)selection.getListWith((TypeReference)new TypeReference<OpenTSDBScanSpec>(){});
        return new OpenTSDBGroupScan(this, scanSpec, null);
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        this.schemaFactory.registerSchemas(schemaConfig, parent);
    }

    public ServiceImpl getClient() {
        return this.db;
    }
}

