/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB;

import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.openTSDB.OpenTSDBRecordReader;
import org.apache.drill.exec.store.openTSDB.OpenTSDBSubScan;

public class OpenTSDBBatchCreator
implements BatchCreator<OpenTSDBSubScan> {
    public CloseableRecordBatch getBatch(ExecutorFragmentContext context, OpenTSDBSubScan subScan, List<RecordBatch> children) throws ExecutionSetupException {
        LinkedList<OpenTSDBRecordReader> readers = new LinkedList<OpenTSDBRecordReader>();
        for (OpenTSDBSubScan.OpenTSDBSubScanSpec scanSpec : subScan.getTabletScanSpecList()) {
            try {
                List columns = subScan.getColumns();
                if (columns == null) {
                    columns = GroupScan.ALL_COLUMNS;
                }
                readers.add(new OpenTSDBRecordReader(subScan.getStorageEngine().getClient(), scanSpec, columns));
            }
            catch (Exception e) {
                throw new ExecutionSetupException((Throwable)e);
            }
        }
        return new ScanBatch((PhysicalOperator)subScan, (FragmentContext)context, readers);
    }
}

