/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.store.openTSDB.SizeEstimator;
import org.junit.Assert;
import org.junit.Test;

public class TestSizeEstimator {
    @Test
    public void testArrays() {
        Assert.assertEquals((long)32L, (long)SizeEstimator.estimate((Object)new byte[10]));
        Assert.assertEquals((long)40L, (long)SizeEstimator.estimate((Object)new char[10]));
        Assert.assertEquals((long)40L, (long)SizeEstimator.estimate((Object)new short[10]));
        Assert.assertEquals((long)56L, (long)SizeEstimator.estimate((Object)new int[10]));
        Assert.assertEquals((long)96L, (long)SizeEstimator.estimate((Object)new long[10]));
        Assert.assertEquals((long)56L, (long)SizeEstimator.estimate((Object)new float[10]));
        Assert.assertEquals((long)96L, (long)SizeEstimator.estimate((Object)new double[10]));
        Assert.assertEquals((long)4016L, (long)SizeEstimator.estimate((Object)new int[1000]));
        Assert.assertEquals((long)8016L, (long)SizeEstimator.estimate((Object)new long[1000]));
        Assert.assertEquals((long)56L, (long)SizeEstimator.estimate((Object)new String[10]));
        Assert.assertEquals((long)56L, (long)SizeEstimator.estimate((Object)new Object[10]));
    }

    @Test
    public void testList() {
        int i;
        ArrayList<Long> list = new ArrayList<Long>();
        for (i = 0; i < 10; ++i) {
            list.add(Long.valueOf(i));
        }
        Assert.assertEquals((long)320L, (long)SizeEstimator.estimate(list));
        for (i = 0; i < 10; ++i) {
            list.add(Long.valueOf(i));
        }
        Assert.assertEquals((long)368L, (long)SizeEstimator.estimate(list));
    }

    @Test
    public void testMetricDTO() {
        HashMap<String, String> tags = new HashMap<String, String>();
        HashMap<String, String> dps = new HashMap<String, String>();
        tags.put("t1", "v1");
        dps.put("dp1", "dpv1");
        ArrayList<String> aggregateTags = new ArrayList<String>();
        TestMetricDTO dto = new TestMetricDTO("metric1", tags, aggregateTags, dps);
        long size = SizeEstimator.estimate((Object)dto);
        Assert.assertTrue((String)("size less then expected: " + size), (size > 550L ? 1 : 0) != 0);
        Assert.assertTrue((String)("size greater then expected: " + size), (size < 800L ? 1 : 0) != 0);
    }

    private static class TestMetricDTO {
        private final String metric;
        private final Map<String, String> tags;
        private final List<String> aggregateTags;
        private final Map<String, String> dps;

        TestMetricDTO(String metric, Map<String, String> tags, List<String> aggregateTags, Map<String, String> dps) {
            this.metric = metric;
            this.tags = tags;
            this.aggregateTags = aggregateTags;
            this.dps = dps;
        }
    }
}

