/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.openTSDB.OpenTSDBStoragePluginConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClientFixture;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class TestOpenTSDBPlugin
extends ClusterTest {
    private static int portNumber;
    @Rule
    public WireMockRule wireMockRule = new WireMockRule(portNumber);

    @BeforeClass
    public static void setup() throws Exception {
        TestOpenTSDBPlugin.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        portNumber = QueryTestUtil.getFreePortNumber((int)10000, (int)200);
        StoragePluginRegistry pluginRegistry = cluster.drillbit().getContext().getStorage();
        OpenTSDBStoragePluginConfig storagePluginConfig = new OpenTSDBStoragePluginConfig(String.format("http://localhost:%s", portNumber));
        storagePluginConfig.setEnabled(Boolean.valueOf(true));
        pluginRegistry.put("openTSDB", (StoragePluginConfig)storagePluginConfig);
    }

    @Before
    public void init() {
        this.setupPostStubs();
        this.setupGetStubs();
    }

    private void setupGetStubs() {
        this.wireMockRule.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/api/suggest?type=metrics&max=2147483647")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody("[\"warp.speed.test\"]")));
        this.wireMockRule.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/api/query?start=47y-ago&m=sum:warp.speed.test")).willReturn(WireMock.aResponse().withStatus(200).withBody("[{\"metric\":\"warp.speed.test\",\"tags\":{},\"aggregateTags\":[\"symbol\"],\"dps\":{\"1407165399\":680.5000152587891,\"1407165401\":904.625,\"1407165402\":904.6124954223633,\"1407165403\":904.5999908447266,\"1407165404\":904.5999908447266,\"1407165405\":904.5999908447266,\"1407165406\":904.5999908447266,\"1407165407\":904.5999908447266,\"1407165408\":904.5999908447266,\"1407165409\":904.5999908447266,\"1407165410\":904.5999908447266,\"1407165419\":904.5999908447266,\"1407165422\":904.6787490844727,\"1407165423\":680.5550068842233,\"1488271956\":111.11000061035156}}]")));
    }

    private void setupPostStubs() {
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/api/query")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"start\":\"47y-ago\",\"end\":null,\"queries\":[{\"aggregator\":\"sum\",\"metric\":\"warp.speed.test\",\"rate\":null,\"downsample\":null,\"tags\":{}}]}")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody("[{\"metric\":\"warp.speed.test\",\"tags\":{},\"aggregateTags\":[\"symbol\"],\"dps\":{\"1407165399\":680.5000152587891,\"1407165401\":904.625,\"1407165402\":904.6124954223633,\"1407165403\":904.5999908447266,\"1407165404\":904.5999908447266,\"1407165405\":904.5999908447266,\"1407165406\":904.5999908447266,\"1407165407\":904.5999908447266,\"1407165408\":904.5999908447266,\"1407165409\":904.5999908447266,\"1407165410\":904.5999908447266,\"1407165419\":904.5999908447266,\"1407165422\":904.6787490844727,\"1407165423\":680.5550068842233,\"1488271956\":111.11000061035156}}]")));
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/api/query")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"start\":\"47y-ago\",\"end\":null,\"queries\":[{\"aggregator\":\"sum\",\"metric\":\"warp.speed.test\",\"rate\":null,\"downsample\":null,\"tags\":{\"symbol\":\"*\"}}]}")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody("[{\"metric\":\"warp.speed.test\",\"tags\":{\"symbol\":\"VOD.L\"},\"aggregateTags\":[],\"dps\":{\"1407165399\":196.3000030517578,\"1407165402\":196.3000030517578,\"1407165405\":196.3000030517578,\"1407165407\":196.3000030517578,\"1407165410\":196.3000030517578,\"1407165422\":196.3000030517578,\"1488271956\":111.11000061035156}},{\"metric\":\"warp.speed.test\",\"tags\":{\"symbol\":\"BP.L\"},\"aggregateTags\":[],\"dps\":{\"1407165399\":484.20001220703125,\"1407165403\":484.1499938964844,\"1407165405\":484.1499938964844,\"1407165408\":484.1499938964844,\"1407165419\":484.1499938964844,\"1407165423\":484.2550048828125}},{\"metric\":\"warp.speed.test\",\"tags\":{\"symbol\":\"BARC.L\"},\"aggregateTags\":[],\"dps\":{\"1407165401\":224.14999389648438,\"1407165404\":224.14999389648438,\"1407165406\":224.14999389648438,\"1407165409\":224.14999389648438,\"1407165422\":224.14999389648438}}]")));
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/api/query")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"start\":\"47y-ago\",\"end\":null,\"queries\":[{\"aggregator\":\"sum\",\"metric\":\"warp.speed.test\",\"rate\":null,\"downsample\":\"5y-avg\",\"tags\":{}}]}")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody("[{\"metric\":\"warp.speed.test\",\"tags\":{},\"aggregateTags\":[\"symbol\"],\"dps\":{\"1261440000\":904.6258290608723,\"1419120000\":111.11000061035156}}]")));
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/api/query")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"start\":\"47y-ago\",\"end\":\"1407165403000\",\"queries\":[{\"aggregator\":\"sum\",\"metric\":\"warp.speed.test\",\"rate\":null,\"downsample\":null,\"tags\":{}}]}")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody("[{\"metric\":\"warp.speed.test\",\"tags\":{},\"aggregateTags\":[\"symbol\"],\"dps\":{\"1407165399\":680.5000152587891,\"1407165401\":904.625,\"1407165402\":904.6124954223633,\"1419120000\":904.5999908447266}}]")));
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/api/query")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"start\":\"47y-ago\",\"end\":null,\"queries\":[{\"aggregator\":\"sum\",\"metric\":\"warp.speed.test\",\"rate\":null,\"downsample\":\"5y-avg\",\"tags\":{\"symbol\":\"*\"}}]}")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody("[{\"metric\":\"warp.speed.test\",\"tags\":{\"symbol\":\"VOD.L\"},\"aggregateTags\":[],\"dps\":{\"1261440000\":196.3000030517578,\"1419120000\":111.11000061035156}},{\"metric\":\"warp.speed.test\",\"tags\":{\"symbol\":\"BP.L\"},\"aggregateTags\":[],\"dps\":{\"1261440000\":484.1758321126302}},{\"metric\":\"warp.speed.test\",\"tags\":{\"symbol\":\"BARC.L\"},\"aggregateTags\":[],\"dps\":{\"1261440000\":224.14999389648438}}]")));
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/api/query")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"start\":\"47y-ago\",\"end\":\"1407165403000\",\"queries\":[{\"aggregator\":\"sum\",\"metric\":\"warp.speed.test\",\"rate\":null,\"downsample\":null,\"tags\":{\"symbol\":\"*\"}}]}")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody("[{\"metric\":\"warp.speed.test\",\"tags\":{\"symbol\":\"VOD.L\"},\"aggregateTags\":[],\"dps\":{\"1407165399\":196.3000030517578,\"1407165402\":196.3000030517578}},{\"metric\":\"warp.speed.test\",\"tags\":{\"symbol\":\"BP.L\"},\"aggregateTags\":[],\"dps\":{\"1407165399\":484.20001220703125,\"1407165403\":484.1499938964844}},{\"metric\":\"warp.speed.test\",\"tags\":{\"symbol\":\"BARC.L\"},\"aggregateTags\":[],\"dps\":{\"1407165401\":224.14999389648438}}]")));
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/api/query")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"start\":\"47y-ago\",\"end\":null,\"queries\":[{\"aggregator\":\"sum\",\"metric\":\"warp.spee\",\"rate\":null,\"downsample\":null,\"tags\":{}}]}")).willReturn(WireMock.aResponse().withStatus(400).withHeader("Content-Type", new String[]{"application/json"})));
    }

    @Test
    public void testBasicQueryFromWithRequiredParams() throws Exception {
        String query = "select * from openTSDB.`(metric=warp.speed.test, start=47y-ago, aggregator=sum)`";
        Assert.assertEquals((long)18L, (long)this.runQuery(query));
    }

    @Test
    public void testBasicQueryGroupBy() throws Exception {
        String query = "select `timestamp`, sum(`aggregated value`) from openTSDB.`(metric=warp.speed.test, aggregator=sum, start=47y-ago)` group by `timestamp`";
        Assert.assertEquals((long)15L, (long)this.runQuery(query));
    }

    @Test
    public void testBasicQueryFromWithInterpolationParam() throws Exception {
        String query = "select * from openTSDB.`(metric=warp.speed.test, aggregator=sum, start=47y-ago, downsample=5y-avg)`";
        Assert.assertEquals((long)4L, (long)this.runQuery(query));
    }

    @Test
    public void testBasicQueryFromWithEndParam() throws Exception {
        String query = "select * from openTSDB.`(metric=warp.speed.test, aggregator=sum, start=47y-ago, end=1407165403000))`";
        Assert.assertEquals((long)5L, (long)this.runQuery(query));
    }

    @Test(expected=UserRemoteException.class)
    public void testBasicQueryWithoutTableName() throws Exception {
        this.runQuery("select * from openTSDB.``;");
    }

    @Test(expected=UserRemoteException.class)
    public void testBasicQueryWithNonExistentTableName() throws Exception {
        this.runQuery("select * from openTSDB.`warp.spee`");
    }

    @Test
    public void testPhysicalPlanSubmission() throws Exception {
        String query = "select * from openTSDB.`(metric=warp.speed.test, start=47y-ago, aggregator=sum)`";
        String plan = this.queryBuilder().sql(query).explainJson();
        this.queryBuilder().query(UserBitShared.QueryType.PHYSICAL, plan).run();
    }

    @Test
    public void testDescribe() throws Exception {
        this.runQuery("use openTSDB");
        this.runQuery("describe `warp.speed.test`");
        Assert.assertEquals((long)1L, (long)this.runQuery("show tables"));
    }

    @Test
    public void testInformationSchemaWrongPluginConfig() throws Exception {
        try (ClusterFixture cluster = ClusterFixture.bareBuilder((BaseDirTestWatcher)dirTestWatcher).build();
             ClientFixture client = cluster.clientFixture();){
            int portNumber = QueryTestUtil.getFreePortNumber((int)10000, (int)200);
            StoragePluginRegistry pluginRegistry = cluster.drillbit().getContext().getStorage();
            OpenTSDBStoragePluginConfig storagePluginConfig = new OpenTSDBStoragePluginConfig(String.format("http://localhost:%s/", portNumber));
            storagePluginConfig.setEnabled(Boolean.valueOf(true));
            pluginRegistry.put("openTSDB", (StoragePluginConfig)storagePluginConfig);
            String query = "select * from information_schema.`views`";
            client.queryBuilder().sql(query).run();
        }
    }

    private long runQuery(String query) throws Exception {
        return this.queryBuilder().sql(query).run().recordCount();
    }
}

