/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB;

import com.google.common.base.Splitter;
import java.util.Map;
import org.apache.drill.common.exceptions.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);

    public static Map<String, String> fromRowData(String rowData) {
        try {
            String fromRowData = rowData.replaceAll("[()]", "");
            return Splitter.on((String)",").trimResults().omitEmptyStrings().withKeyValueSeparator("=").split((CharSequence)fromRowData);
        }
        catch (IllegalArgumentException e) {
            throw UserException.validationError().message(String.format("Syntax error in the query %s", rowData), new Object[0]).build(log);
        }
    }

    public static String getValidTableName(String name) {
        if (!Util.isTableNameValid(name)) {
            name = Util.fromRowData(name).get("metric");
        }
        return name;
    }

    public static boolean isTableNameValid(String name) {
        return !name.contains("=");
    }
}

