/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.openTSDB.OpenTSDBScanSpec;
import org.apache.drill.exec.store.openTSDB.OpenTSDBStoragePlugin;
import org.apache.drill.exec.store.openTSDB.OpenTSDBStoragePluginConfig;
import org.apache.drill.exec.store.openTSDB.OpenTSDBSubScan;
import org.apache.drill.exec.store.openTSDB.SizeEstimator;
import org.apache.drill.exec.store.openTSDB.Util;
import org.apache.drill.exec.store.openTSDB.client.services.ServiceImpl;
import org.apache.drill.exec.store.openTSDB.dto.MetricDTO;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

@JsonTypeName(value="openTSDB-scan")
public class OpenTSDBGroupScan
extends AbstractGroupScan {
    private OpenTSDBStoragePluginConfig storagePluginConfig;
    private OpenTSDBScanSpec openTSDBScanSpec;
    private OpenTSDBStoragePlugin storagePlugin;
    private List<SchemaPath> columns;

    @JsonCreator
    public OpenTSDBGroupScan(@JsonProperty(value="openTSDBScanSpec") OpenTSDBScanSpec openTSDBScanSpec, @JsonProperty(value="storage") OpenTSDBStoragePluginConfig openTSDBStoragePluginConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JacksonInject StoragePluginRegistry pluginRegistry) throws IOException, ExecutionSetupException {
        this((OpenTSDBStoragePlugin)pluginRegistry.getPlugin((StoragePluginConfig)openTSDBStoragePluginConfig), openTSDBScanSpec, columns);
    }

    public OpenTSDBGroupScan(OpenTSDBStoragePlugin storagePlugin, OpenTSDBScanSpec scanSpec, List<SchemaPath> columns) {
        super((String)null);
        this.storagePlugin = storagePlugin;
        this.storagePluginConfig = storagePlugin.getConfig();
        this.openTSDBScanSpec = scanSpec;
        this.columns = columns == null || columns.size() == 0 ? ALL_COLUMNS : columns;
    }

    private OpenTSDBGroupScan(OpenTSDBGroupScan that) {
        super((String)null);
        this.columns = that.columns;
        this.openTSDBScanSpec = that.openTSDBScanSpec;
        this.storagePlugin = that.storagePlugin;
        this.storagePluginConfig = that.storagePluginConfig;
    }

    public int getMaxParallelizationWidth() {
        return 1;
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> incomingEndpoints) {
    }

    public OpenTSDBSubScan getSpecificScan(int minorFragmentId) {
        ArrayList scanSpecList = Lists.newArrayList();
        scanSpecList.add(new OpenTSDBSubScan.OpenTSDBSubScanSpec(this.getTableName()));
        return new OpenTSDBSubScan(this.storagePlugin, this.storagePluginConfig, scanSpecList, this.columns);
    }

    public ScanStats getScanStats() {
        ServiceImpl client = this.storagePlugin.getClient();
        Map<String, String> params = Util.fromRowData(this.openTSDBScanSpec.getTableName());
        Set<MetricDTO> allMetrics = client.getAllMetrics(params);
        long numMetrics = allMetrics.size();
        float approxDiskCost = 0.0f;
        if (numMetrics != 0L) {
            MetricDTO metricDTO = allMetrics.iterator().next();
            approxDiskCost = SizeEstimator.estimate(metricDTO) * numMetrics;
        }
        return new ScanStats(ScanStats.GroupScanProperty.EXACT_ROW_COUNT, (double)numMetrics, 1.0, (double)approxDiskCost);
    }

    @JsonIgnore
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new OpenTSDBGroupScan(this);
    }

    public String getDigest() {
        return this.toString();
    }

    @JsonIgnore
    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    @JsonIgnore
    public String getTableName() {
        return this.getOpenTSDBScanSpec().getTableName();
    }

    @JsonProperty
    public OpenTSDBScanSpec getOpenTSDBScanSpec() {
        return this.openTSDBScanSpec;
    }

    @JsonProperty(value="storage")
    public OpenTSDBStoragePluginConfig getStoragePluginConfig() {
        return this.storagePluginConfig;
    }

    @JsonProperty
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public GroupScan clone(List<SchemaPath> columns) {
        OpenTSDBGroupScan newScan = new OpenTSDBGroupScan(this);
        newScan.columns = columns;
        return newScan;
    }

    public String toString() {
        return "OpenTSDBGroupScan [OpenTSDBScanSpec=" + this.openTSDBScanSpec + ", columns=" + this.columns + "]";
    }
}

