/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo.config;

import com.google.common.base.Preconditions;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.sys.BasePersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;
import org.apache.drill.exec.store.sys.PersistentStoreMode;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoPersistentStore<V>
extends BasePersistentStore<V> {
    private static final Logger logger = LoggerFactory.getLogger(MongoPersistentStore.class);
    private final PersistentStoreConfig<V> config;
    private final MongoCollection<Document> collection;

    public MongoPersistentStore(PersistentStoreConfig<V> config, MongoCollection<Document> collection) {
        throw new UnsupportedOperationException("Mongo DB PStore not currently supported");
    }

    public PersistentStoreMode getMode() {
        return PersistentStoreMode.PERSISTENT;
    }

    public boolean contains(String key) {
        try {
            Bson query = Filters.eq((String)"_id", (Object)key);
            Document document = (Document)this.collection.find(query).first();
            return document != null && document.containsKey((Object)"pKey");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public V get(String key) {
        try {
            Bson query = Filters.eq((String)"_id", (Object)key);
            Document document = (Document)this.collection.find(query).first();
            if (document != null) {
                return this.value((byte[])document.get((Object)"pKey"));
            }
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void put(String key, V value) {
        try {
            Document putObj = new Document("_id", (Object)key).append("pKey", (Object)this.bytes(value));
            this.collection.insertOne((Object)putObj);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean putIfAbsent(String key, V value) {
        try {
            Bson query = Filters.eq((String)"_id", (Object)key);
            Bson update = Updates.set((String)"pKey", (Object)this.bytes(value));
            UpdateResult updateResult = this.collection.updateOne(query, update, new UpdateOptions().upsert(true));
            return updateResult.getModifiedCount() == 1L;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void delete(String key) {
        try {
            Bson query = Filters.eq((String)"_id", (Object)key);
            this.collection.deleteOne(query);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private byte[] bytes(V value) {
        try {
            return this.config.getSerializer().serialize(value);
        }
        catch (IOException e) {
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private V value(byte[] serialize) {
        try {
            return (V)this.config.getSerializer().deserialize(serialize);
        }
        catch (IOException e) {
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public Iterator<Map.Entry<String, V>> getRange(int skip, int take) {
        MongoCursor cursor = this.collection.find().skip(skip).limit(take).iterator();
        return new MongoIterator((MongoCursor<Document>)cursor);
    }

    public void close() {
    }

    private class DeferredEntry
    implements Map.Entry<String, V> {
        private Document result;

        public DeferredEntry(Document result) {
            this.result = result;
        }

        @Override
        public String getKey() {
            return this.result.get((Object)"_id").toString();
        }

        @Override
        public V getValue() {
            return MongoPersistentStore.this.get(this.result.get((Object)"_id").toString());
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private class MongoIterator
    implements Iterator<Map.Entry<String, V>> {
        private MongoCursor<Document> cursor;

        public MongoIterator(MongoCursor<Document> cursor) {
            this.cursor = (MongoCursor)Preconditions.checkNotNull(cursor);
        }

        @Override
        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return new DeferredEntry((Document)this.cursor.next());
        }

        @Override
        public void remove() {
            this.cursor.remove();
        }
    }
}

