/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.mongo.BaseMongoSubScanSpec;
import org.apache.drill.exec.store.mongo.MongoStoragePlugin;
import org.apache.drill.exec.store.mongo.MongoStoragePluginConfig;

@JsonTypeName(value="mongo-shard-read")
public class MongoSubScan
extends AbstractBase
implements SubScan {
    public static final String OPERATOR_TYPE = "MONGO_SUB_SCAN";
    @JsonProperty
    private final MongoStoragePluginConfig mongoPluginConfig;
    @JsonIgnore
    private final MongoStoragePlugin mongoStoragePlugin;
    private final List<SchemaPath> columns;
    private final List<BaseMongoSubScanSpec> chunkScanSpecList;

    @JsonCreator
    public MongoSubScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="userName") String userName, @JsonProperty(value="mongoPluginConfig") StoragePluginConfig mongoPluginConfig, @JsonProperty(value="chunkScanSpecList") LinkedList<BaseMongoSubScanSpec> chunkScanSpecList, @JsonProperty(value="columns") List<SchemaPath> columns) {
        super(userName);
        this.columns = columns;
        this.mongoPluginConfig = (MongoStoragePluginConfig)mongoPluginConfig;
        this.mongoStoragePlugin = (MongoStoragePlugin)registry.resolve(mongoPluginConfig, MongoStoragePlugin.class);
        this.chunkScanSpecList = chunkScanSpecList;
    }

    public MongoSubScan(String userName, MongoStoragePlugin storagePlugin, MongoStoragePluginConfig storagePluginConfig, List<BaseMongoSubScanSpec> chunkScanSpecList, List<SchemaPath> columns) {
        super(userName);
        this.mongoStoragePlugin = storagePlugin;
        this.mongoPluginConfig = storagePluginConfig;
        this.columns = columns;
        this.chunkScanSpecList = chunkScanSpecList;
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    @JsonIgnore
    public MongoStoragePlugin getMongoStoragePlugin() {
        return this.mongoStoragePlugin;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public List<BaseMongoSubScanSpec> getChunkScanSpecList() {
        return this.chunkScanSpecList;
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new MongoSubScan(this.getUserName(), this.mongoStoragePlugin, this.mongoPluginConfig, this.chunkScanSpecList, this.columns);
    }

    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public Iterator<PhysicalOperator> iterator() {
        return Collections.emptyIterator();
    }

    @JsonDeserialize(builder=MongoSubScanSpecBuilder.class)
    public static class MongoSubScanSpec
    extends BaseMongoSubScanSpec {
        @JsonProperty
        private final List<String> operations;

        protected MongoSubScanSpec(MongoSubScanSpecBuilder b) {
            super(b);
            this.operations = b.operations;
        }

        public static MongoSubScanSpecBuilder builder() {
            return new MongoSubScanSpecBuilder();
        }

        public List<String> getOperations() {
            return this.operations;
        }

        public String toString() {
            return new PlanStringBuilder((Object)this).field("bName", this.getDbName()).field("collectionName", this.getCollectionName()).field("hosts", this.getHosts()).field("operations", this.operations).toString();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class MongoSubScanSpecBuilder
        extends BaseMongoSubScanSpec.BaseMongoSubScanSpecBuilder<MongoSubScanSpecBuilder> {
            private List<String> operations;

            public MongoSubScanSpecBuilder operations(List<String> operations) {
                this.operations = operations;
                return this.self();
            }

            @Override
            protected MongoSubScanSpecBuilder self() {
                return this;
            }

            public MongoSubScanSpec build() {
                return new MongoSubScanSpec(this);
            }
        }
    }

    @JsonDeserialize(builder=ShardedMongoSubScanSpecBuilder.class)
    public static class ShardedMongoSubScanSpec
    extends BaseMongoSubScanSpec {
        @JsonProperty
        private final Map<String, Object> minFilters;
        @JsonProperty
        private final Map<String, Object> maxFilters;
        @JsonProperty
        private final String filter;

        protected ShardedMongoSubScanSpec(ShardedMongoSubScanSpecBuilder b) {
            super(b);
            this.minFilters = b.minFilters;
            this.maxFilters = b.maxFilters;
            this.filter = b.filter;
        }

        public static ShardedMongoSubScanSpecBuilder builder() {
            return new ShardedMongoSubScanSpecBuilder();
        }

        public Map<String, Object> getMinFilters() {
            return this.minFilters;
        }

        public Map<String, Object> getMaxFilters() {
            return this.maxFilters;
        }

        public String getFilter() {
            return this.filter;
        }

        public String toString() {
            return new PlanStringBuilder((Object)this).field("bName", this.getDbName()).field("collectionName", this.getCollectionName()).field("hosts", this.getHosts()).field("minFilters", this.minFilters).field("maxFilters", this.maxFilters).field("filter", this.filter).toString();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class ShardedMongoSubScanSpecBuilder
        extends BaseMongoSubScanSpec.BaseMongoSubScanSpecBuilder<ShardedMongoSubScanSpecBuilder> {
            private Map<String, Object> minFilters;
            private Map<String, Object> maxFilters;
            private String filter;

            public ShardedMongoSubScanSpecBuilder minFilters(Map<String, Object> minFilters) {
                this.minFilters = minFilters;
                return this.self();
            }

            public ShardedMongoSubScanSpecBuilder maxFilters(Map<String, Object> maxFilters) {
                this.maxFilters = maxFilters;
                return this.self();
            }

            public ShardedMongoSubScanSpecBuilder filter(String filter) {
                this.filter = filter;
                return this.self();
            }

            @Override
            public ShardedMongoSubScanSpecBuilder self() {
                return this;
            }

            public ShardedMongoSubScanSpec build() {
                return new ShardedMongoSubScanSpec(this);
            }
        }
    }
}

