/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.drill.categories.MongoStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.mongo.MongoTestConstants;
import org.apache.drill.exec.store.mongo.TestMongoChunkAssignment;
import org.apache.drill.exec.store.mongo.TestMongoDrillIssue;
import org.apache.drill.exec.store.mongo.TestMongoFilterPushDown;
import org.apache.drill.exec.store.mongo.TestMongoLimitPushDown;
import org.apache.drill.exec.store.mongo.TestMongoProjectPushDown;
import org.apache.drill.exec.store.mongo.TestMongoQueries;
import org.apache.drill.exec.store.mongo.TestMongoStoragePluginUsesCredentialsStore;
import org.apache.drill.exec.store.mongo.TestTableGenerator;
import org.apache.hadoop.conf.Configuration;
import org.bson.conversions.Bson;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.images.builder.Transferable;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={TestMongoFilterPushDown.class, TestMongoProjectPushDown.class, TestMongoQueries.class, TestMongoLimitPushDown.class, TestMongoChunkAssignment.class, TestMongoStoragePluginUsesCredentialsStore.class, TestMongoDrillIssue.class})
@Category(value={SlowTest.class, MongoStorageTest.class})
public class MongoTestSuite
implements MongoTestConstants {
    private static final Logger logger = LoggerFactory.getLogger(MongoTestSuite.class);
    protected static MongoClient mongoClient;
    private static final boolean distMode;
    private static volatile String connectionURL;
    private static final AtomicInteger initCount;
    private static ContainerManager containerManager;

    public static String getConnectionURL() {
        return connectionURL;
    }

    private static GenericContainer<?> newContainer(Network network, String host) {
        GenericContainer container = new GenericContainer("mongo:4.4.10").withNetwork(network).withNetworkAliases(new String[]{host}).withExposedPorts(new Integer[]{27017}).withCommand(String.format("mongod --port %d --shardsvr --replSet rs0 --bind_ip localhost,%s", 27017, host));
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void initMongo() throws Exception {
        Class<MongoTestSuite> clazz = MongoTestSuite.class;
        synchronized (MongoTestSuite.class) {
            if (initCount.get() == 0) {
                if (distMode) {
                    logger.info("Executing tests in distributed mode");
                    containerManager = new DistributedMode();
                } else {
                    logger.info("Executing tests in single mode");
                    containerManager = new SingleMode();
                }
                connectionURL = containerManager.setup();
                containerManager.getMasterContainer().copyFileToContainer(Transferable.of((byte[])Files.asCharSource((File)new File(Resources.getResource((String)"emp.json").toURI()), (Charset)StandardCharsets.UTF_8).read().getBytes(StandardCharsets.UTF_8)), "emp.json");
                containerManager.getMasterContainer().copyFileToContainer(Transferable.of((byte[])Files.asCharSource((File)new File(Resources.getResource((String)"schema_change_int_to_string.json").toURI()), (Charset)StandardCharsets.UTF_8).read().getBytes(StandardCharsets.UTF_8)), "schema_change_int_to_string.json");
                containerManager.getMasterContainer().copyFileToContainer(Transferable.of((byte[])Files.asCharSource((File)new File(Resources.getResource((String)"donuts.json").toURI()), (Charset)StandardCharsets.UTF_8).read().getBytes(StandardCharsets.UTF_8)), "donuts.json");
                containerManager.getMasterContainer().copyFileToContainer(Transferable.of((byte[])Files.asCharSource((File)new File(Resources.getResource((String)"datatype-oid.json").toURI()), (Charset)StandardCharsets.UTF_8).read().getBytes(StandardCharsets.UTF_8)), "datatype-oid.json");
                TestTableGenerator.importData(containerManager.getMasterContainer(), "employee", "empinfo", "emp.json");
                TestTableGenerator.importData(containerManager.getMasterContainer(), "employee", "schema_change", "schema_change_int_to_string.json");
                TestTableGenerator.importData(containerManager.getMasterContainer(), "donuts", "donuts", "donuts.json");
                TestTableGenerator.importData(containerManager.getMasterContainer(), "datatype", "types", "datatype-oid.json");
                TestTableGenerator.importData(containerManager.getMasterContainer(), "ISSUE7820", "Issue7820", "emp.json");
            }
            initCount.incrementAndGet();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void createDbAndCollections(String dbName, String collectionName, String indexFieldName) {
        MongoDatabase db = mongoClient.getDatabase(dbName);
        MongoCollection mongoCollection = db.getCollection(collectionName);
        if (mongoCollection == null) {
            db.createCollection(collectionName);
            mongoCollection = db.getCollection(collectionName);
        }
        if (indexFieldName.equals("_id")) {
            return;
        }
        IndexOptions indexOptions = new IndexOptions().unique(true).background(false).name(indexFieldName);
        Bson keys = Indexes.ascending((String[])new String[]{indexFieldName});
        mongoCollection.createIndex(keys, indexOptions);
    }

    private static void createMongoUser() throws IOException {
        Configuration configuration = new Configuration();
        String storeName = "mongo";
        char[] usernameChars = configuration.getPassword("drill.exec.store." + storeName + ".username");
        char[] passwordChars = configuration.getPassword("drill.exec.store." + storeName + ".password");
        if (usernameChars != null && passwordChars != null) {
            String username = URLEncoder.encode(new String(usernameChars), "UTF-8");
            String password = URLEncoder.encode(new String(passwordChars), "UTF-8");
            BasicDBObject createUserCommand = new BasicDBObject("createUser", (Object)username).append("pwd", (Object)password).append("roles", Collections.singletonList(new BasicDBObject("role", (Object)"readWrite").append("db", (Object)"admin")));
            MongoDatabase db = mongoClient.getDatabase("admin");
            db.runCommand((Bson)createUserCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownCluster() {
        Class<MongoTestSuite> clazz = MongoTestSuite.class;
        synchronized (MongoTestSuite.class) {
            if (initCount.decrementAndGet() == 0) {
                try {
                    if (mongoClient != null) {
                        mongoClient.getDatabase("employee").drop();
                        mongoClient.getDatabase("datatype").drop();
                        mongoClient.getDatabase("donuts").drop();
                    }
                }
                finally {
                    if (mongoClient != null) {
                        mongoClient.close();
                    }
                    containerManager.cleanup();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        distMode = Boolean.parseBoolean(System.getProperty("drill.mongo.tests.shardMode", "false"));
        connectionURL = null;
        initCount = new AtomicInteger(0);
    }

    public static class SingleMode
    extends ContainerManager {
        @Override
        public String setup() throws IOException {
            mongoContainers = Collections.singletonList(new GenericContainer("mongo:4.4.10").withNetwork(Network.SHARED).withNetworkAliases(new String[]{"M1"}).withExposedPorts(new Integer[]{27017}).withCommand("--replSet rs0 --bind_ip localhost,M1"));
            mongoContainers.forEach(GenericContainer::start);
            GenericContainer master = this.getMasterContainer();
            try {
                master.execInContainer(new String[]{"/bin/bash", "-c", "mongo --eval 'printjson(rs.initiate({_id:\"rs0\",members:[{_id:0,host:\"M1:27017\"}]}))' --quiet"});
                master.execInContainer(new String[]{"/bin/bash", "-c", "until mongo --eval \"printjson(rs.isMaster())\" | grep ismaster | grep true > /dev/null 2>&1;do sleep 1;done"});
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to initiate rs.", e);
            }
            String connectionString = String.format("mongodb://%s:%d", master.getContainerIpAddress(), master.getFirstMappedPort());
            mongoClient = MongoClients.create((String)connectionString);
            MongoTestSuite.createMongoUser();
            MongoTestSuite.createDbAndCollections("employee", "empinfo", "employee_id");
            MongoTestSuite.createDbAndCollections("employee", "schema_change", "field_2");
            MongoTestSuite.createDbAndCollections("employee", "empty", "field_2");
            MongoTestSuite.createDbAndCollections("datatype", "types", "_id");
            return connectionString;
        }
    }

    private static class DistributedMode
    extends ContainerManager {
        private DistributedMode() {
        }

        @Override
        public String setup() throws Exception {
            Network network = Network.newNetwork();
            Stream.of("m1", "m2", "m3").map(host -> MongoTestSuite.newContainer(network, host)).collect(Collectors.toList());
            String configServerHost = "m4";
            GenericContainer configServer = new GenericContainer("mongo:4.4.10").withNetwork(network).withNetworkAliases(new String[]{configServerHost}).withExposedPorts(new Integer[]{27017}).withCommand(String.format("mongod --configsvr --port %s --replSet rs0conf --bind_ip localhost,%s", 27017, configServerHost));
            configServer.start();
            Container.ExecResult execResult = configServer.execInContainer(new String[]{"/bin/bash", "-c", String.format("echo 'rs.initiate({_id: \"rs0conf\",configsvr: true, members: [{ _id : 0, host : \"%s:%2$s\" }]})' | mongo --port %2$s", configServerHost, 27017)});
            logger.info(execResult.toString());
            String mongosHost = "m5";
            GenericContainer mongos = new GenericContainer("mongo:4.4.10").withNetwork(network).withNetworkAliases(new String[]{mongosHost}).withExposedPorts(new Integer[]{27017}).withCommand(String.format("mongos --configdb rs0conf/%1$s:%2$s --bind_ip localhost,%3$s --port %2$s", configServerHost, 27017, mongosHost));
            mongos.start();
            mongoContainers.forEach(GenericContainer::start);
            GenericContainer<?> master = this.getMasterContainer();
            execResult = master.execInContainer(new String[]{"/bin/bash", "-c", String.format("mongo --port %1$s --eval 'printjson(rs.initiate({_id:\"rs0\",members:[{_id:0,host:\"m1:%1$s\"},{_id:1,host:\"m2:%1$s\"},{_id:2,host:\"m3:%1$s\"}]}))' --quiet", 27017)});
            logger.info(execResult.toString());
            execResult = master.execInContainer(new String[]{"/bin/bash", "-c", String.format("until mongo --port %s --eval \"printjson(rs.isMaster())\" | grep ismaster | grep true > /dev/null 2>&1;do sleep 1;done", 27017)});
            logger.info(execResult.toString());
            execResult = mongos.execInContainer(new String[]{"/bin/bash", "-c", "echo 'sh.addShard(\"rs0/m1\")' | mongo --port 27017"});
            logger.info(execResult.toString());
            String replicaSetUrl = String.format("mongodb://%s:%s", mongos.getContainerIpAddress(), mongos.getMappedPort(27017));
            mongoClient = MongoClients.create((String)replicaSetUrl);
            logger.info("Execute list shards.");
            execResult = master.execInContainer(new String[]{"/bin/bash", "-c", "mongo --eval 'db.adminCommand({ listShards: 1 })' --port 27017"});
            logger.info(execResult.toString());
            logger.info("Enabled sharding at database level");
            execResult = mongos.execInContainer(new String[]{"/bin/bash", "-c", String.format("mongo --eval 'db.adminCommand( {\n   enableSharding: \"%s\"\n} )'", "employee")});
            logger.info(execResult.toString());
            logger.info("Create index in sharded collection");
            MongoDatabase db = mongoClient.getDatabase("employee");
            db.getCollection("empinfo").createIndex(Indexes.ascending((String[])new String[]{"employee_id"}));
            logger.info("Shard the collection: {}.{}", (Object)"employee", (Object)"empinfo");
            execResult = mongos.execInContainer(new String[]{"/bin/bash", "-c", String.format("echo 'sh.shardCollection(\"%s.%s\", {\"employee_id\" : 1})' | mongo ", "employee", "empinfo")});
            logger.info(execResult.toString());
            MongoTestSuite.createMongoUser();
            MongoTestSuite.createDbAndCollections("donuts", "donuts", "id");
            MongoTestSuite.createDbAndCollections("employee", "empty", "field_2");
            MongoTestSuite.createDbAndCollections("datatype", "types", "_id");
            return String.format("mongodb://%s:%s", "localhost", mongos.getMappedPort(27017));
        }
    }

    private static abstract class ContainerManager {
        protected static List<GenericContainer<?>> mongoContainers;

        private ContainerManager() {
        }

        public abstract String setup() throws Exception;

        public void cleanup() {
            mongoContainers.forEach(GenericContainer::stop);
        }

        public GenericContainer<?> getMasterContainer() {
            return mongoContainers.iterator().next();
        }
    }
}

