/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.categories.MongoStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.mongo.MongoGroupScan;
import org.apache.drill.exec.store.mongo.MongoScanSpec;
import org.apache.drill.exec.store.mongo.common.ChunkInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, MongoStorageTest.class})
public class TestMongoChunkAssignment {
    static final String HOST_A = "A";
    static final String HOST_B = "B";
    static final String HOST_C = "C";
    static final String HOST_D = "D";
    static final String HOST_E = "E";
    static final String HOST_F = "F";
    static final String HOST_G = "G";
    static final String HOST_H = "H";
    static final String HOST_I = "I";
    static final String HOST_J = "J";
    static final String HOST_K = "K";
    static final String HOST_L = "L";
    static final String HOST_M = "M";
    static final String HOST_X = "X";
    static final String dbName = "testDB";
    static final String collectionName = "testCollection";
    private Map<String, Set<ServerAddress>> chunksMapping;
    private Map<String, List<ChunkInfo>> chunksInverseMapping;
    private MongoGroupScan mongoGroupScan;

    @Before
    public void setUp() throws UnknownHostException {
        this.chunksMapping = Maps.newHashMap();
        this.chunksInverseMapping = Maps.newLinkedHashMap();
        HashSet hosts_A = Sets.newHashSet();
        hosts_A.add(new ServerAddress(HOST_A));
        this.chunksMapping.put("testDB.testCollection-01", hosts_A);
        this.chunksMapping.put("testDB.testCollection-05", hosts_A);
        ChunkInfo chunk1Info = new ChunkInfo(Arrays.asList(HOST_A), "testDB.testCollection-01");
        chunk1Info.setMinFilters(Collections.emptyMap());
        HashMap chunk1MaxFilters = Maps.newHashMap();
        chunk1MaxFilters.put("name", 5);
        chunk1Info.setMaxFilters((Map)chunk1MaxFilters);
        ChunkInfo chunk5Info = new ChunkInfo(Arrays.asList(HOST_A), "testDB.testCollection-05");
        HashMap chunk5MinFilters = Maps.newHashMap();
        chunk5MinFilters.put("name", 25);
        chunk5Info.setMinFilters((Map)chunk5MinFilters);
        HashMap chunk5MaxFilters = Maps.newHashMap();
        chunk5MaxFilters.put("name", 30);
        chunk5Info.setMaxFilters((Map)chunk5MaxFilters);
        List<ChunkInfo> chunkList = Arrays.asList(chunk1Info, chunk5Info);
        this.chunksInverseMapping.put(HOST_A, chunkList);
        HashSet hosts_B = Sets.newHashSet();
        hosts_A.add(new ServerAddress(HOST_B));
        this.chunksMapping.put("testDB.testCollection-02", hosts_B);
        ChunkInfo chunk2Info = new ChunkInfo(Arrays.asList(HOST_B), "testDB.testCollection-02");
        HashMap chunk2MinFilters = Maps.newHashMap();
        chunk2MinFilters.put("name", 5);
        chunk2Info.setMinFilters((Map)chunk2MinFilters);
        HashMap chunk2MaxFilters = Maps.newHashMap();
        chunk2MaxFilters.put("name", 15);
        chunk2Info.setMaxFilters((Map)chunk2MaxFilters);
        chunkList = Arrays.asList(chunk2Info);
        this.chunksInverseMapping.put(HOST_B, chunkList);
        HashSet hosts_C = Sets.newHashSet();
        hosts_A.add(new ServerAddress(HOST_C));
        this.chunksMapping.put("testDB.testCollection-03", hosts_C);
        this.chunksMapping.put("testDB.testCollection-06", hosts_C);
        ChunkInfo chunk3Info = new ChunkInfo(Arrays.asList(HOST_C), "testDB.testCollection-03");
        HashMap chunk3MinFilters = Maps.newHashMap();
        chunk5MinFilters.put("name", 15);
        chunk3Info.setMinFilters((Map)chunk3MinFilters);
        HashMap chunk3MaxFilters = Maps.newHashMap();
        chunk3MaxFilters.put("name", 20);
        chunk3Info.setMaxFilters((Map)chunk3MaxFilters);
        ChunkInfo chunk6Info = new ChunkInfo(Arrays.asList(HOST_C), "testDB.testCollection-06");
        HashMap chunk6MinFilters = Maps.newHashMap();
        chunk5MinFilters.put("name", 25);
        chunk6Info.setMinFilters((Map)chunk6MinFilters);
        HashMap chunk6MaxFilters = Maps.newHashMap();
        chunk5MaxFilters.put("name", 30);
        chunk6Info.setMaxFilters((Map)chunk6MaxFilters);
        chunkList = Arrays.asList(chunk3Info, chunk6Info);
        this.chunksInverseMapping.put(HOST_C, chunkList);
        HashSet hosts_D = Sets.newHashSet();
        hosts_A.add(new ServerAddress(HOST_D));
        this.chunksMapping.put("testDB.testCollection-04", hosts_D);
        ChunkInfo chunk4Info = new ChunkInfo(Arrays.asList(HOST_D), "testDB.testCollection-04");
        HashMap chunk4MinFilters = Maps.newHashMap();
        chunk4MinFilters.put("name", 20);
        chunk4Info.setMinFilters((Map)chunk4MinFilters);
        HashMap chunk4MaxFilters = Maps.newHashMap();
        chunk4MaxFilters.put("name", 25);
        chunk4Info.setMaxFilters((Map)chunk4MaxFilters);
        chunkList = Arrays.asList(chunk4Info);
        this.chunksInverseMapping.put(HOST_D, chunkList);
        this.mongoGroupScan = new MongoGroupScan();
        this.mongoGroupScan.setChunksMapping(this.chunksMapping);
        this.mongoGroupScan.setInverseChunksMapping(this.chunksInverseMapping);
        MongoScanSpec scanSpec = new MongoScanSpec(dbName, collectionName);
        this.mongoGroupScan.setScanSpec(scanSpec);
    }

    @Test
    public void testMongoGroupScanAssignmentMix() throws UnknownHostException, ExecutionSetupException {
        ArrayList endpoints = Lists.newArrayList();
        CoordinationProtos.DrillbitEndpoint DB_A = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_A).setControlPort(1234).build();
        endpoints.add(DB_A);
        endpoints.add(DB_A);
        CoordinationProtos.DrillbitEndpoint DB_B = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_B).setControlPort(1234).build();
        endpoints.add(DB_B);
        CoordinationProtos.DrillbitEndpoint DB_D = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_D).setControlPort(1234).build();
        endpoints.add(DB_D);
        CoordinationProtos.DrillbitEndpoint DB_X = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_X).setControlPort(1234).build();
        endpoints.add(DB_X);
        this.mongoGroupScan.applyAssignments((List)endpoints);
        Assert.assertEquals((long)1L, (long)this.mongoGroupScan.getSpecificScan(0).getChunkScanSpecList().size());
        Assert.assertEquals((long)1L, (long)this.mongoGroupScan.getSpecificScan(1).getChunkScanSpecList().size());
        Assert.assertEquals((long)1L, (long)this.mongoGroupScan.getSpecificScan(2).getChunkScanSpecList().size());
        Assert.assertEquals((long)1L, (long)this.mongoGroupScan.getSpecificScan(3).getChunkScanSpecList().size());
        Assert.assertEquals((long)2L, (long)this.mongoGroupScan.getSpecificScan(4).getChunkScanSpecList().size());
    }

    @Test
    public void testMongoGroupScanAssignmentAllAffinity() throws UnknownHostException, ExecutionSetupException {
        ArrayList endpoints = Lists.newArrayList();
        CoordinationProtos.DrillbitEndpoint DB_A = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_A).setControlPort(1234).build();
        endpoints.add(DB_A);
        CoordinationProtos.DrillbitEndpoint DB_B = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_B).setControlPort(1234).build();
        endpoints.add(DB_B);
        CoordinationProtos.DrillbitEndpoint DB_C = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_C).setControlPort(1234).build();
        endpoints.add(DB_C);
        CoordinationProtos.DrillbitEndpoint DB_D = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_D).setControlPort(1234).build();
        endpoints.add(DB_D);
        this.mongoGroupScan.applyAssignments((List)endpoints);
        Assert.assertEquals((long)2L, (long)this.mongoGroupScan.getSpecificScan(0).getChunkScanSpecList().size());
        Assert.assertEquals((long)1L, (long)this.mongoGroupScan.getSpecificScan(1).getChunkScanSpecList().size());
        Assert.assertEquals((long)2L, (long)this.mongoGroupScan.getSpecificScan(2).getChunkScanSpecList().size());
        Assert.assertEquals((long)1L, (long)this.mongoGroupScan.getSpecificScan(3).getChunkScanSpecList().size());
    }

    @Test
    public void testMongoGroupScanAssignmentNoAffinity() throws UnknownHostException, ExecutionSetupException {
        ArrayList endpoints = Lists.newArrayList();
        CoordinationProtos.DrillbitEndpoint DB_M = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_M).setControlPort(1234).build();
        endpoints.add(DB_M);
        endpoints.add(DB_M);
        CoordinationProtos.DrillbitEndpoint DB_L = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_L).setControlPort(1234).build();
        endpoints.add(DB_L);
        CoordinationProtos.DrillbitEndpoint DB_X = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_X).setControlPort(1234).build();
        endpoints.add(DB_X);
        this.mongoGroupScan.applyAssignments((List)endpoints);
        Assert.assertEquals((long)1L, (long)this.mongoGroupScan.getSpecificScan(0).getChunkScanSpecList().size());
        Assert.assertEquals((long)2L, (long)this.mongoGroupScan.getSpecificScan(1).getChunkScanSpecList().size());
        Assert.assertEquals((long)2L, (long)this.mongoGroupScan.getSpecificScan(2).getChunkScanSpecList().size());
        Assert.assertEquals((long)1L, (long)this.mongoGroupScan.getSpecificScan(3).getChunkScanSpecList().size());
    }

    @Test
    public void testMongoGroupScanAssignmentWhenOnlyOneDrillBit() throws UnknownHostException, ExecutionSetupException {
        ArrayList endpoints = Lists.newArrayList();
        CoordinationProtos.DrillbitEndpoint DB_A = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(HOST_A).setControlPort(1234).build();
        endpoints.add(DB_A);
        this.mongoGroupScan.applyAssignments((List)endpoints);
        Assert.assertEquals((long)6L, (long)this.mongoGroupScan.getSpecificScan(0).getChunkScanSpecList().size());
    }
}

