/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.mongodb.MongoCredential;
import com.mongodb.client.internal.MongoClientImpl;
import org.apache.drill.categories.MongoStorageTest;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.store.mongo.MongoStoragePlugin;
import org.apache.drill.exec.store.mongo.MongoStoragePluginConfig;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MongoStorageTest.class})
public class TestMongoStoragePluginUsesCredentialsStore {
    private void test(String expectedUserName, String expectedPassword, String connection, String name) throws ExecutionSetupException {
        MongoStoragePlugin plugin = new MongoStoragePlugin(new MongoStoragePluginConfig(connection, null, Integer.valueOf(100), false, PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER), null, name);
        MongoClientImpl client = (MongoClientImpl)plugin.getClient();
        MongoCredential cred = client.getSettings().getCredential();
        if (expectedUserName == null) {
            Assert.assertNull((Object)cred);
        } else {
            Assert.assertNotNull((Object)cred);
            Assert.assertEquals((Object)expectedUserName, (Object)cred.getUserName());
            Assert.assertEquals((Object)expectedPassword, (Object)new String(cred.getPassword()));
        }
    }

    @Test
    public void usesPasswordFromCoreSiteXml() throws Exception {
        this.test("test", "pw", "mongodb://example:27017/somedb?readPreference=primary", "mongo");
    }

    @Test
    public void supportsInterpolation() throws Exception {
        this.test("mooch_test", "mooch_pw", "mongodb://example:27017/somedb?readPreference=primary", "mongomooch");
    }

    @Test
    public void doesNotReplaceExistingCredentials() throws Exception {
        this.test("u", "p", "mongodb://u:p@example:27017/somedb?readPreference=primary", "mongo");
    }

    @Test
    public void urlEncodesCredentials() throws Exception {
        this.test("!@#$%//:+^*()", ":;[]}{!@#/?$#@", "mongodb://example:27017/somedb?readPreference=primary", "mongosec");
    }

    @Test
    public void doesNotAddCredentialsIfNoneFound() throws Exception {
        this.test(null, null, "mongodb://example:27017/somedb?readPreference=primary", "mongopublic");
    }
}

