/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import org.apache.drill.categories.MongoStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.mongo.MongoTestBase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, MongoStorageTest.class})
public class TestMongoQueries
extends MongoTestBase {
    @Test
    public void testBooleanFilter() throws Exception {
        this.testBuilder().sqlQuery(String.format("select `employee_id` from mongo.%s.`%s` where isFTE = true", "employee", "empinfo")).unOrdered().expectsNumRecords(11).go();
        this.testBuilder().sqlQuery(String.format("select `employee_id` from mongo.%s.`%s` where isFTE = false", "employee", "empinfo")).unOrdered().expectsNumRecords(8).go();
    }

    @Test
    public void testSerDe() throws Exception {
        String plan = this.queryBuilder().sql(String.format("select `employee_id` from mongo.%s.`%s` where isFTE = true", "employee", "empinfo")).explainJson();
        Assert.assertEquals((long)this.queryBuilder().physical(plan).run().recordCount(), (long)11L);
    }

    @Test
    public void testFragmentSerDe() throws Exception {
        client.alterSession("planner.slice_target", (Object)1);
        try {
            String plan = this.queryBuilder().sql(String.format("select t1.id as id, t1.name from mongo.%1$s.`%2$s` t1 where t1.name = 'Cake' union select t2.id as id, t2.name from mongo.%1$s.`%2$s` t2 ", "donuts", "donuts")).explainJson();
            Assert.assertEquals((long)this.queryBuilder().physical(plan).run().recordCount(), (long)5L);
        }
        finally {
            client.resetSession("planner.slice_target");
        }
    }

    @Test
    public void testWithANDOperator() throws Exception {
        this.testBuilder().sqlQuery(String.format("select `employee_id` from mongo.%s.`%s` where position_id = 16 and isFTE = true", "employee", "empinfo")).unOrdered().expectsNumRecords(4).go();
    }

    @Test
    public void testWithOROperator() throws Exception {
        this.testBuilder().sqlQuery(String.format("select `employee_id` from mongo.%s.`%s` where position_id = 16 and isFTE = true", "employee", "empinfo")).unOrdered().expectsNumRecords(4).go();
    }

    @Test
    public void testResultCount() throws Exception {
        this.testBuilder().sqlQuery(String.format("select `employee_id` from mongo.%s.`%s` where (position_id = 16 and isFTE = true) or last_name = 'Yonce'", "employee", "empinfo")).unOrdered().expectsNumRecords(5).go();
    }

    @Test
    public void testUnShardedDBInShardedCluster() throws Exception {
        this.testBuilder().sqlQuery(String.format("select * from mongo.%s.`%s`", "donuts", "donuts")).unOrdered().expectsNumRecords(5).go();
    }

    @Test
    public void testEmptyCollection() throws Exception {
        this.testBuilder().sqlQuery(String.format("select * from mongo.%s.`%s`", "employee", "empty")).unOrdered().expectsNumRecords(0).go();
    }

    @Test
    @Ignore(value="DRILL-7428")
    public void testUnShardedDBInShardedClusterWithProjectionAndFilter() throws Exception {
        this.testBuilder().sqlQuery(String.format("select t.name as name, t.topping.type as type from mongo.%s.`%s` t where t.sales >= 150", "donuts", "donuts")).unOrdered().expectsNumRecords(2).go();
    }

    @Test
    @Ignore(value="DRILL-7428")
    public void testUnShardedDBInShardedClusterWithGroupByProjectionAndFilter() throws Exception {
        this.testBuilder().sqlQuery(String.format("select t.topping.type as type, count(t.topping.type) as typeCount from mongo.%s.`%s` t group by t.topping.type order by typeCount", "donuts", "donuts")).unOrdered().expectsNumRecords(5).go();
    }

    @Test
    public void testCountColumnPushDown() throws Exception {
        String query = "select count(t.name) as c from mongo.%s.`%s` t";
        this.queryBuilder().sql(query, new Object[]{"donuts", "donuts"}).planMatcher().exclude(new String[]{"Agg\\("}).include(new String[]{"MongoGroupScan.*group"}).match();
        this.testBuilder().sqlQuery(query, new Object[]{"donuts", "donuts"}).unOrdered().baselineColumns(new String[]{"c"}).baselineValues(new Object[]{5}).go();
    }

    @Test
    public void testSumColumnPushDown() throws Exception {
        String query = "select sum(t.sales) as s from mongo.%s.`%s` t";
        this.queryBuilder().sql(query, new Object[]{"donuts", "donuts"}).planMatcher().exclude(new String[]{"Agg\\("}).include(new String[]{"MongoGroupScan.*group"}).match();
        this.testBuilder().sqlQuery(query, new Object[]{"donuts", "donuts"}).unOrdered().baselineColumns(new String[]{"s"}).baselineValues(new Object[]{1194}).go();
    }

    @Test
    public void testCountGroupByPushDown() throws Exception {
        String query = "select count(t.id) as c, t.type from mongo.%s.`%s` t group by t.type";
        this.queryBuilder().sql(query, new Object[]{"donuts", "donuts"}).planMatcher().exclude(new String[]{"Agg\\("}).include(new String[]{"MongoGroupScan.*group"}).match();
        this.testBuilder().sqlQuery(query, new Object[]{"donuts", "donuts"}).unOrdered().baselineColumns(new String[]{"c", "type"}).baselineValues(new Object[]{5, "donut"}).go();
    }

    @Test
    public void testSumGroupByPushDown() throws Exception {
        String query = "select sum(t.sales) s, t.type from mongo.%s.`%s` t group by t.type";
        this.queryBuilder().sql(query, new Object[]{"donuts", "donuts"}).planMatcher().exclude(new String[]{"Agg\\("}).include(new String[]{"MongoGroupScan.*group"}).match();
        this.testBuilder().sqlQuery(query, new Object[]{"donuts", "donuts"}).unOrdered().baselineColumns(new String[]{"s", "type"}).baselineValues(new Object[]{1194, "donut"}).go();
    }

    @Test
    public void testCountColumnPushDownWithFilter() throws Exception {
        String query = "select count(t.id) as c from mongo.%s.`%s` t where t.name = 'Cake'";
        this.queryBuilder().sql(query, new Object[]{"donuts", "donuts"}).planMatcher().exclude(new String[]{"Agg\\(", "Filter"}).include(new String[]{"MongoGroupScan.*group"}).match();
        this.testBuilder().sqlQuery(query, new Object[]{"donuts", "donuts"}).unOrdered().baselineColumns(new String[]{"c"}).baselineValues(new Object[]{1}).go();
    }

    @Test
    public void testUnionAll() throws Exception {
        String query = "select t1.id as id, t1.name from mongo.%1$s.`%2$s` t1 where t1.name = 'Cake' union all select t2.id as id, t2.name from mongo.%1$s.`%2$s` t2";
        this.queryBuilder().sql(query, new Object[]{"donuts", "donuts"}).planMatcher().exclude(new String[]{"UnionAll\\("}).include(new String[]{"MongoGroupScan.*\\$unionWith"}).match();
        this.testBuilder().sqlQuery(query, new Object[]{"donuts", "donuts"}).unOrdered().baselineColumns(new String[]{"id", "name"}).baselineValues(new Object[]{"0001", "Cake"}).baselineValues(new Object[]{"0001", "Cake"}).baselineValues(new Object[]{"0002", "Raised"}).baselineValues(new Object[]{"0003", "Old Fashioned"}).baselineValues(new Object[]{"0004", "Filled"}).baselineValues(new Object[]{"0005", "Apple Fritter"}).go();
    }

    @Test
    public void testUnionDistinct() throws Exception {
        String query = "select t1.id as id, t1.name from mongo.%1$s.`%2$s` t1 where t1.name = 'Cake' union select t2.id as id, t2.name from mongo.%1$s.`%2$s` t2 ";
        this.queryBuilder().sql(query, new Object[]{"donuts", "donuts"}).planMatcher().exclude(new String[]{"UnionAll\\(", "Agg\\("}).include(new String[]{"MongoGroupScan.*\\$unionWith"}).match();
        this.testBuilder().sqlQuery(query, new Object[]{"donuts", "donuts"}).unOrdered().baselineColumns(new String[]{"id", "name"}).baselineValues(new Object[]{"0001", "Cake"}).baselineValues(new Object[]{"0002", "Raised"}).baselineValues(new Object[]{"0003", "Old Fashioned"}).baselineValues(new Object[]{"0004", "Filled"}).baselineValues(new Object[]{"0005", "Apple Fritter"}).go();
    }

    @Test
    public void testProjectPushDown() throws Exception {
        String query = "select t.sales * t.sales as c, t.name from mongo.%s.`%s` t";
        this.queryBuilder().sql(query, new Object[]{"donuts", "donuts"}).planMatcher().include(new String[]{"MongoGroupScan.*project.*multiply"}).match();
        this.testBuilder().sqlQuery(query, new Object[]{"donuts", "donuts"}).unOrdered().baselineColumns(new String[]{"c", "name"}).baselineValues(new Object[]{196, "Filled"}).baselineValues(new Object[]{1225, "Cake"}).baselineValues(new Object[]{21025, "Raised"}).baselineValues(new Object[]{90000, "Old Fashioned"}).baselineValues(new Object[]{490000, "Apple Fritter"}).go();
    }

    @Test
    public void testProjectPushDownWithCase() throws Exception {
        String query = "select case when t.sales >= 700 then 2 when t.sales > 145 then 1 else 0 end as c, t.name from mongo.%s.`%s` t";
        this.queryBuilder().sql(query, new Object[]{"donuts", "donuts"}).planMatcher().include(new String[]{"MongoGroupScan.*project.*cond.*\\$gt"}).match();
        this.testBuilder().sqlQuery(query, new Object[]{"donuts", "donuts"}).unOrdered().baselineColumns(new String[]{"c", "name"}).baselineValues(new Object[]{0, "Filled"}).baselineValues(new Object[]{0, "Cake"}).baselineValues(new Object[]{0, "Raised"}).baselineValues(new Object[]{1, "Old Fashioned"}).baselineValues(new Object[]{2, "Apple Fritter"}).go();
    }
}

