/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.bson;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocator;
import org.apache.drill.exec.ops.BufferManager;
import org.apache.drill.exec.ops.BufferManagerImpl;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.store.TestOutputMutator;
import org.apache.drill.exec.store.bson.BsonRecordReader;
import org.apache.drill.exec.vector.complex.impl.SingleMapReaderImpl;
import org.apache.drill.exec.vector.complex.impl.VectorContainerWriter;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.test.BaseTest;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWriter;
import org.bson.BsonDouble;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBsonRecordReader
extends BaseTest {
    private BufferAllocator allocator;
    private VectorContainerWriter writer;
    private BufferManager bufferManager;
    private BsonRecordReader bsonReader;

    @Before
    public void setUp() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
        TestOutputMutator mutator = new TestOutputMutator(this.allocator);
        this.writer = new VectorContainerWriter((OutputMutator)mutator);
        this.bufferManager = new BufferManagerImpl(this.allocator);
        this.bsonReader = new BsonRecordReader(this.bufferManager.getManagedBuffer(1024), false, false);
    }

    @Test
    public void testIntType() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        bsonDoc.append("seqNo", (BsonValue)new BsonInt64(10L));
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        Assert.assertEquals((long)10L, (long)mapReader.reader("seqNo").readLong());
    }

    @Test
    public void testTimeStampType() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        bsonDoc.append("ts_small", (BsonValue)new BsonTimestamp(1000, 10));
        bsonDoc.append("ts_large", (BsonValue)new BsonTimestamp(1000000000, 10));
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        Assert.assertEquals((long)1000000L, (long)mapReader.reader("ts_small").readLocalDateTime().atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli());
        Assert.assertEquals((long)1000000000000L, (long)mapReader.reader("ts_large").readLocalDateTime().atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli());
    }

    @Test
    public void testSymbolType() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        bsonDoc.append("symbolKey", (BsonValue)new BsonSymbol("test_symbol"));
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        Assert.assertEquals((Object)"test_symbol", (Object)mapReader.reader("symbolKey").readText().toString());
    }

    @Test
    public void testStringType() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        bsonDoc.append("stringKey", (BsonValue)new BsonString("test_string"));
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        Assert.assertEquals((Object)"test_string", (Object)mapReader.reader("stringKey").readText().toString());
    }

    @Test
    public void testSpecialCharStringType() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        bsonDoc.append("stringKey", (BsonValue)new BsonString("\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a71"));
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        Assert.assertEquals((Object)"\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a71", (Object)mapReader.reader("stringKey").readText().toString());
    }

    @Test
    public void testObjectIdType() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        BsonObjectId value = new BsonObjectId(new ObjectId());
        bsonDoc.append("_idKey", (BsonValue)value);
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        byte[] readByteArray = mapReader.reader("_idKey").readByteArray();
        Assert.assertArrayEquals((byte[])value.getValue().toByteArray(), (byte[])readByteArray);
    }

    @Test
    public void testNullType() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        bsonDoc.append("nullKey", (BsonValue)new BsonNull());
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        Assert.assertNull((Object)mapReader.reader("nullKey").readObject());
    }

    @Test
    public void testDoubleType() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        bsonDoc.append("doubleKey", (BsonValue)new BsonDouble(12.35));
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        Assert.assertEquals((double)12.35, (double)mapReader.reader("doubleKey").readDouble(), (double)1.0E-5);
    }

    @Test
    public void testArrayOfDocumentType() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        BsonDocumentWriter bw = new BsonDocumentWriter(bsonDoc);
        bw.writeStartDocument();
        bw.writeName("a");
        bw.writeString("MongoDB");
        bw.writeName("b");
        bw.writeStartArray();
        bw.writeStartDocument();
        bw.writeName("c");
        bw.writeInt32(1);
        bw.writeEndDocument();
        bw.writeEndArray();
        bw.writeEndDocument();
        bw.flush();
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        FieldReader reader = this.writer.getMapVector().getReader();
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)reader;
        FieldReader reader3 = mapReader.reader("b");
        Assert.assertEquals((Object)"MongoDB", (Object)mapReader.reader("a").readText().toString());
    }

    @Test
    public void testRecursiveDocuments() throws IOException {
        BsonDocument topDoc = new BsonDocument();
        int count = 3;
        for (int i = 0; i < 3; ++i) {
            BsonDocument bsonDoc = new BsonDocument();
            BsonDocumentWriter bw = new BsonDocumentWriter(bsonDoc);
            bw.writeStartDocument();
            bw.writeName("k1" + i);
            bw.writeString("drillMongo1" + i);
            bw.writeName("k2" + i);
            bw.writeString("drillMongo2" + i);
            bw.writeEndDocument();
            bw.flush();
            topDoc.append("doc" + i, (BsonValue)bsonDoc);
        }
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(topDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        for (int i = 0; i < 3; ++i) {
            SingleMapReaderImpl reader = (SingleMapReaderImpl)mapReader.reader("doc" + i);
            Assert.assertEquals((Object)("drillMongo1" + i), (Object)reader.reader("k1" + i).readText().toString());
            Assert.assertEquals((Object)("drillMongo2" + i), (Object)reader.reader("k2" + i).readText().toString());
        }
    }

    @Test
    public void testDateTimeType() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        bsonDoc.append("dateTimeKey", (BsonValue)new BsonDateTime(5262729712L));
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        Assert.assertEquals((long)5262729712L, (long)mapReader.reader("dateTimeKey").readLocalDateTime().atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli());
    }

    @Test
    public void testBooleanType() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        bsonDoc.append("booleanKey", (BsonValue)new BsonBoolean(true));
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        Assert.assertTrue((boolean)mapReader.reader("booleanKey").readBoolean());
    }

    @Test
    public void testBinaryTypes() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        byte[] bytes = "binaryValue".getBytes(StandardCharsets.UTF_8);
        bsonDoc.append("binaryKey", (BsonValue)new BsonBinary(BsonBinarySubType.BINARY, bytes));
        byte[] bytesString = "binaryStringValue".getBytes(StandardCharsets.UTF_8);
        bsonDoc.append("binaryStringKey", (BsonValue)new BsonBinary(2, bytesString));
        byte[] bytesDouble = new byte[8];
        ByteBuffer.wrap(bytesDouble).putDouble(23.0123);
        BsonBinary bsonDouble = new BsonBinary(1, bytesDouble);
        bsonDoc.append("binaryDouble", (BsonValue)bsonDouble);
        byte[] booleanBytes = new byte[8];
        ByteBuffer.wrap(booleanBytes).put((byte)1);
        BsonBinary bsonBoolean = new BsonBinary(8, booleanBytes);
        bsonDoc.append("bsonBoolean", (BsonValue)bsonBoolean);
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        Assert.assertArrayEquals((byte[])bytes, (byte[])mapReader.reader("binaryKey").readByteArray());
        Assert.assertEquals((Object)"binaryStringValue", (Object)mapReader.reader("binaryStringKey").readText().toString());
        Assert.assertEquals((double)23.0123, (double)mapReader.reader("binaryDouble").readDouble(), (double)0.0);
        FieldReader reader = mapReader.reader("bsonBoolean");
        Assert.assertEquals((Object)true, (Object)reader.readBoolean());
    }

    @Test
    public void testArrayType() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        BsonDocumentWriter bw = new BsonDocumentWriter(bsonDoc);
        bw.writeStartDocument();
        bw.writeName("arrayKey");
        bw.writeStartArray();
        bw.writeInt32(1);
        bw.writeInt32(2);
        bw.writeInt32(3);
        bw.writeEndArray();
        bw.writeEndDocument();
        bw.flush();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        FieldReader reader = mapReader.reader("arrayKey");
        Assert.assertEquals((long)3L, (long)reader.size());
    }

    @Test
    public void testDecimal128Type() throws IOException {
        BsonDocument bsonDoc = new BsonDocument();
        bsonDoc.append("decimal128Key", (BsonValue)new BsonDecimal128(Decimal128.parse((String)"12.12345624")));
        this.writer.reset();
        this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDoc));
        SingleMapReaderImpl mapReader = (SingleMapReaderImpl)this.writer.getMapVector().getReader();
        Assert.assertEquals((Object)new BigDecimal("12.12345624"), (Object)mapReader.reader("decimal128Key").readBigDecimal());
    }

    @After
    public void cleanUp() {
        try {
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bufferManager.close();
        this.allocator.close();
    }
}

