/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import org.apache.drill.categories.MongoStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.mongo.MongoTestBase;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, MongoStorageTest.class})
public class TestMongoFilterPushDown
extends MongoTestBase {
    @Test
    public void testFilterPushDownIsEqual() throws Exception {
        String queryString = String.format("SELECT `full_name` FROM mongo.%s.`%s` where rating = 52.17", "employee", "empinfo");
        this.testBuilder().sqlQuery(queryString).unOrdered().expectsNumRecords(1).go();
    }

    @Test
    public void testFilterPushDownLessThanWithSingleField() throws Exception {
        String queryString = String.format("SELECT `full_name` FROM mongo.%s.`%s` where rating < 52.17", "employee", "empinfo");
        this.testBuilder().sqlQuery(queryString).unOrdered().expectsNumRecords(9).go();
    }

    @Test
    public void testFilterPushDownGreaterThanWithSingleField() throws Exception {
        String queryString = String.format("SELECT `full_name` FROM mongo.%s.`%s` where rating > 52.17", "employee", "empinfo");
        this.testBuilder().sqlQuery(queryString).unOrdered().expectsNumRecords(9).go();
    }

    @Test
    public void testFilterPushDownIsNull() throws Exception {
        String queryString = String.format("SELECT `employee_id` FROM mongo.%s.`%s` where position_id is null", "employee", "empinfo");
        this.testBuilder().sqlQuery(queryString).unOrdered().expectsNumRecords(2).go();
    }

    @Test
    public void testFilterPushDownIsNotNull() throws Exception {
        String queryString = String.format("SELECT `employee_id` FROM mongo.%s.`%s` where position_id is not null", "employee", "empinfo");
        this.testBuilder().sqlQuery(queryString).unOrdered().expectsNumRecords(17).go();
    }
}

