/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.mongodb.ConnectionString;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.drill.common.logical.AbstractSecuredStoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;

@JsonTypeName(value="mongo")
public class MongoStoragePluginConfig
extends AbstractSecuredStoragePluginConfig {
    public static final String NAME = "mongo";
    private final String connection;
    private final boolean allowDiskUse;
    @JsonIgnore
    private final ConnectionString clientURI;
    private final MongoPluginOptimizations pluginOptimizations;
    private final int batchSize;

    @JsonCreator
    public MongoStoragePluginConfig(@JsonProperty(value="connection") String connection, @JsonProperty(value="pluginOptimizations") MongoPluginOptimizations pluginOptimizations, @JsonProperty(value="batchSize") Integer batchSize, @JsonProperty(value="allowDiskUse") boolean allowDiskUse, @JsonProperty(value="credentialsProvider") CredentialsProvider credentialsProvider) {
        super(MongoStoragePluginConfig.getCredentialsProvider(credentialsProvider), credentialsProvider == null);
        this.connection = connection;
        this.clientURI = new ConnectionString(connection);
        this.pluginOptimizations = (MongoPluginOptimizations)ObjectUtils.defaultIfNull((Object)pluginOptimizations, (Object)new MongoPluginOptimizations());
        this.batchSize = batchSize != null ? batchSize : 100;
        this.allowDiskUse = allowDiskUse;
    }

    public MongoPluginOptimizations getPluginOptimizations() {
        return this.pluginOptimizations;
    }

    @JsonIgnore
    public List<String> getHosts() {
        return this.clientURI.getHosts();
    }

    public String getConnection() {
        return this.connection;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="allowDiskUse")
    public boolean allowDiskUse() {
        return this.allowDiskUse;
    }

    private static CredentialsProvider getCredentialsProvider(CredentialsProvider credentialsProvider) {
        return credentialsProvider != null ? credentialsProvider : PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MongoStoragePluginConfig that = (MongoStoragePluginConfig)((Object)o);
        return Objects.equals(this.connection, that.connection);
    }

    public int hashCode() {
        return Objects.hash(this.connection);
    }

    public static class MongoPluginOptimizations {
        private boolean supportsProjectPushdown = true;
        private boolean supportsFilterPushdown = true;
        private boolean supportsAggregatePushdown = true;
        private boolean supportsSortPushdown = true;
        private boolean supportsUnionPushdown = true;
        private boolean supportsLimitPushdown = true;

        public boolean isSupportsProjectPushdown() {
            return this.supportsProjectPushdown;
        }

        public boolean isSupportsFilterPushdown() {
            return this.supportsFilterPushdown;
        }

        public boolean isSupportsAggregatePushdown() {
            return this.supportsAggregatePushdown;
        }

        public boolean isSupportsSortPushdown() {
            return this.supportsSortPushdown;
        }

        public boolean isSupportsUnionPushdown() {
            return this.supportsUnionPushdown;
        }

        public boolean isSupportsLimitPushdown() {
            return this.supportsLimitPushdown;
        }

        public void setSupportsProjectPushdown(boolean supportsProjectPushdown) {
            this.supportsProjectPushdown = supportsProjectPushdown;
        }

        public void setSupportsFilterPushdown(boolean supportsFilterPushdown) {
            this.supportsFilterPushdown = supportsFilterPushdown;
        }

        public void setSupportsAggregatePushdown(boolean supportsAggregatePushdown) {
            this.supportsAggregatePushdown = supportsAggregatePushdown;
        }

        public void setSupportsSortPushdown(boolean supportsSortPushdown) {
            this.supportsSortPushdown = supportsSortPushdown;
        }

        public void setSupportsUnionPushdown(boolean supportsUnionPushdown) {
            this.supportsUnionPushdown = supportsUnionPushdown;
        }

        public void setSupportsLimitPushdown(boolean supportsLimitPushdown) {
            this.supportsLimitPushdown = supportsLimitPushdown;
        }
    }
}

