/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import org.apache.drill.categories.MongoStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.mongo.MongoTestBase;
import org.apache.drill.test.TestBuilder;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, MongoStorageTest.class})
public class TestMongoProjectPushDown
extends MongoTestBase {
    @Test
    public void testComplexProjectPushdown() throws Exception {
        this.queryBuilder().sql("select t.field_4.inner_3 as col_1, t.field_4 as col_2 from mongo.employee.schema_change t").planMatcher().include(new String[]{"MongoGroupScan.*\"\\$project\": \\{\"col_1\": \"\\$field_4.inner_3\", \"col_2\": \"\\$field_4\"\\}"}).match();
        try {
            this.testBuilder().sqlQuery("select t.field_4.inner_3 as col_1, t.field_4 as col_2 from mongo.employee.schema_change t").unOrdered().optionSettingQueriesForTestQuery(String.format("alter session set `%s` = true", "store.mongo.read_numbers_as_double")).baselineColumns(new String[]{"col_1", "col_2"}).baselineValues(new Object[]{TestBuilder.mapOf((Object[])new Object[0]), TestBuilder.mapOf((Object[])new Object[]{"inner_1", TestBuilder.listOf((Object[])new Object[0]), "inner_3", TestBuilder.mapOf((Object[])new Object[0])})}).baselineValues(new Object[]{TestBuilder.mapOf((Object[])new Object[]{"inner_object_field_1", 2.0}), TestBuilder.mapOf((Object[])new Object[]{"inner_1", TestBuilder.listOf((Object[])new Object[]{1.0, 2.0, 3.0}), "inner_2", 3.0, "inner_3", TestBuilder.mapOf((Object[])new Object[]{"inner_object_field_1", 2.0})})}).baselineValues(new Object[]{TestBuilder.mapOf((Object[])new Object[0]), TestBuilder.mapOf((Object[])new Object[]{"inner_1", TestBuilder.listOf((Object[])new Object[]{4.0, 5.0, 6.0}), "inner_2", 3.0, "inner_3", TestBuilder.mapOf((Object[])new Object[0])})}).go();
        }
        catch (Throwable throwable) {
            TestMongoProjectPushDown.run((String)"alter session set `%s` = false", (Object[])new Object[]{"store.mongo.read_numbers_as_double"});
            throw throwable;
        }
        TestMongoProjectPushDown.run((String)"alter session set `%s` = false", (Object[])new Object[]{"store.mongo.read_numbers_as_double"});
    }

    @Test
    public void testSingleColumnProject() throws Exception {
        String query = String.format("SELECT `employee_id` FROM mongo.%s.`%s`", "employee", "empinfo");
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"employee_id"}).expectsNumRecords(19).go();
    }

    @Test
    public void testMultipleColumnsProject() throws Exception {
        String query = String.format("select `employee_id`, `rating`, coalesce(`full_name`, 'Bob') from mongo.%s.`%s`", "employee", "empinfo");
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"employee_id", "rating"}).expectsNumRecords(19).go();
    }

    @Test
    public void testStarProject() throws Exception {
        String query = String.format("select * from mongo.%s.`%s`", "employee", "empinfo");
        this.testBuilder().sqlQuery(query).unOrdered().expectsNumRecords(19).go();
    }

    @Test
    public void testOperatorsProject() throws Exception {
        String query = String.format("select coalesce(`position_id`, -1) position_id_or_default from mongo.%s.`%s`", "employee", "empinfo");
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"position_id_or_default"}).expectsNumRecords(19).go();
    }

    @Test
    public void testProjectWithJoin() throws Exception {
        String query = "SELECT sum(s1.sales) s1_sales,\nsum(s2.sales) s2_sales\nFROM mongo.%s.`%s` s1\nJOIN mongo.%s.`%s` s2 ON s1._id = s2._id";
        this.queryBuilder().sql(query, new Object[]{"donuts", "donuts", "donuts", "donuts"}).planMatcher().include(new String[]{"columns=\\[`_id`, `sales`]"}).exclude(new String[]{"columns=\\[`\\*\\*`"}).match();
        this.testBuilder().sqlQuery(query, new Object[]{"donuts", "donuts", "donuts", "donuts"}).unOrdered().baselineColumns(new String[]{"s1_sales", "s2_sales"}).baselineValues(new Object[]{1194L, 1194L}).go();
    }
}

