/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import org.apache.drill.categories.MongoStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.mongo.MongoTestBase;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, MongoStorageTest.class})
public class TestMongoLimitPushDown
extends MongoTestBase {
    @Test
    public void testLimit() throws Exception {
        String sql = "SELECT `employee_id` FROM mongo.employee.`empinfo` LIMIT 4";
        this.queryBuilder().sql(sql).planMatcher().exclude(new String[]{"Limit\\("}).include(new String[]{"MongoGroupScan.*\"\\$limit\": 4"}).match();
    }

    @Test
    public void testLimitWithOrderBy() throws Exception {
        String sql = "SELECT `employee_id` FROM mongo.employee.`empinfo` ORDER BY employee_id LIMIT 4";
        this.queryBuilder().sql(sql).planMatcher().exclude(new String[]{"Limit"}).include(new String[]{"MongoGroupScan.*\"\\$sort\": \\{\"employee_id\": 1}", "\"\\$limit\": 4"}).match();
    }

    @Test
    public void testLimitWithOffset() throws Exception {
        String sql = "SELECT `employee_id` FROM mongo.employee.`empinfo` LIMIT 4 OFFSET 5";
        this.queryBuilder().sql(sql).planMatcher().exclude(new String[]{"Limit"}).include(new String[]{"\"\\$skip\": 5", "\"\\$limit\": 4"}).match();
    }

    @Test
    public void testLimitWithFilter() throws Exception {
        String sql = "SELECT `employee_id` FROM mongo.employee.`empinfo` WHERE rating = 52.17 LIMIT 4";
        this.queryBuilder().sql(sql).planMatcher().exclude(new String[]{"Limit"}).include(new String[]{"\"\\$limit\": 4", "\"\\$eq\": 52\\.17"}).match();
    }

    @Test
    public void testSelectStarWithLimit() throws Exception {
        this.testBuilder().sqlQuery("SELECT * FROM mongo.employee.`empinfo` LIMIT 4").unOrdered().expectsNumRecords(4).go();
    }
}

