/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.mongo.MongoStoragePluginConfig;
import org.apache.drill.exec.store.mongo.MongoTestConstants;
import org.apache.drill.exec.store.mongo.MongoTestSuite;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class MongoTestBase
extends ClusterTest
implements MongoTestConstants {
    private static StoragePluginRegistry pluginRegistry;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        MongoTestBase.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        pluginRegistry = cluster.drillbit().getContext().getStorage();
        MongoTestSuite.initMongo();
        MongoTestBase.initMongoStoragePlugin(MongoTestSuite.getConnectionURL());
    }

    private static void initMongoStoragePlugin(String connectionURI) throws Exception {
        MongoStoragePluginConfig storagePluginConfig = new MongoStoragePluginConfig(connectionURI, null, Integer.valueOf(100), false, PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER);
        storagePluginConfig.setEnabled(Boolean.valueOf(true));
        pluginRegistry.put("mongo", (StoragePluginConfig)storagePluginConfig);
        client.testBuilder().sqlQuery("alter session set `%s` = %s", new Object[]{"store.mongo.bson.record.reader", System.getProperty("drill.mongo.tests.bson.reader", "true")}).unOrdered().expectsEmptyResultSet();
    }

    @AfterClass
    public static void tearDownMongoTestBase() throws Exception {
        pluginRegistry.remove("mongo");
        MongoTestSuite.tearDownCluster();
    }
}

