/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo.schema;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.Table;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.mongo.schema.MongoSchemaFactory;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDatabaseSchema
extends AbstractSchema {
    static final Logger logger = LoggerFactory.getLogger(MongoDatabaseSchema.class);
    private final MongoSchemaFactory.MongoSchema mongoSchema;
    private final Set<String> tableNames;
    private final Map<String, DrillTable> drillTables = Maps.newHashMap();

    public MongoDatabaseSchema(List<String> tableList, MongoSchemaFactory.MongoSchema mongoSchema, String name) {
        super(mongoSchema.getSchemaPath(), name);
        this.mongoSchema = mongoSchema;
        this.tableNames = Sets.newHashSet(tableList);
    }

    public Table getTable(String tableName) {
        if (!this.tableNames.contains(tableName)) {
            return null;
        }
        if (!this.drillTables.containsKey(tableName)) {
            this.drillTables.put(tableName, this.mongoSchema.getDrillTable(this.name, tableName));
        }
        return (Table)this.drillTables.get(tableName);
    }

    public Set<String> getTableNames() {
        return this.tableNames;
    }

    public String getTypeName() {
        return "mongo";
    }
}

