/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import java.util.List;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="mongo")
public class MongoStoragePluginConfig
extends StoragePluginConfig {
    static final Logger logger = LoggerFactory.getLogger(MongoStoragePluginConfig.class);
    public static final String NAME = "mongo";
    private String connection;
    @JsonIgnore
    private MongoClientURI clientURI;

    @JsonCreator
    public MongoStoragePluginConfig(@JsonProperty(value="connection") String connection) {
        this.connection = connection;
        this.clientURI = new MongoClientURI(connection);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        MongoStoragePluginConfig thatConfig = (MongoStoragePluginConfig)((Object)that);
        return this.connection.equals(thatConfig.connection);
    }

    public int hashCode() {
        return this.connection != null ? this.connection.hashCode() : 0;
    }

    @JsonIgnore
    public MongoCredential getMongoCrendials() {
        return this.clientURI.getCredentials();
    }

    @JsonIgnore
    public MongoClientOptions getMongoOptions() {
        return this.clientURI.getOptions();
    }

    @JsonIgnore
    public List<String> getHosts() {
        return this.clientURI.getHosts();
    }

    public String getConnection() {
        return this.connection;
    }
}

