/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import de.flapdoodle.embed.mongo.MongoImportExecutable;
import de.flapdoodle.embed.mongo.MongoImportProcess;
import de.flapdoodle.embed.mongo.MongoImportStarter;
import de.flapdoodle.embed.mongo.config.IMongoImportConfig;
import de.flapdoodle.embed.mongo.config.MongoImportConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import org.apache.drill.exec.store.mongo.MongoTestConstants;
import org.apache.drill.shaded.guava.com.google.common.io.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTableGenerator
implements MongoTestConstants {
    private static final Logger logger = LoggerFactory.getLogger(TestTableGenerator.class);

    public static void importData(String dbName, String collectionName, String fileName) throws InterruptedException, IOException {
        String jsonFile = Resources.getResource((String)fileName).toString();
        jsonFile = jsonFile.replaceFirst("file:", "");
        TestTableGenerator.generateTable(dbName, collectionName, jsonFile, true, true, false);
    }

    public static void generateTable(String dbName, String collection, String jsonFile, Boolean jsonArray, Boolean upsert, Boolean drop) throws InterruptedException, IOException {
        logger.info("Started importing file {} into collection {} ", (Object)jsonFile, (Object)collection);
        IMongoImportConfig mongoImportConfig = new MongoImportConfigBuilder().version((IFeatureAwareVersion)Version.Main.V3_4).net(new Net(27017, Network.localhostIsIPv6())).db(dbName).collection(collection).upsert(upsert.booleanValue()).dropCollection(drop.booleanValue()).jsonArray(jsonArray.booleanValue()).importFile(jsonFile).build();
        MongoImportExecutable importExecutable = (MongoImportExecutable)MongoImportStarter.getDefaultInstance().prepare((IExecutableProcessConfig)mongoImportConfig);
        MongoImportProcess importProcess = (MongoImportProcess)importExecutable.start();
        while (importProcess.isProcessRunning()) {
            Thread.sleep(1000L);
        }
        logger.info("Imported file {} into collection {} ", (Object)jsonFile, (Object)collection);
    }
}

