/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import org.apache.drill.categories.MongoStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.mongo.MongoTestBase;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, MongoStorageTest.class})
public class TestMongoQueries
extends MongoTestBase {
    @Test
    public void testBooleanFilter() throws Exception {
        String queryString = String.format("select `employee_id` from mongo.%s.`%s` where isFTE = true", "employee", "empinfo");
        this.runMongoSQLVerifyCount(queryString, 11);
        queryString = String.format("select `employee_id` from mongo.%s.`%s` where isFTE = false", "employee", "empinfo");
        this.runMongoSQLVerifyCount(queryString, 8);
    }

    @Test
    public void testWithANDOperator() throws Exception {
        String queryString = String.format("select `employee_id` from mongo.%s.`%s` where position_id = 16 and isFTE = true", "employee", "empinfo");
        this.runMongoSQLVerifyCount(queryString, 4);
    }

    @Test
    public void testWithOROperator() throws Exception {
        String queryString = String.format("select `employee_id` from mongo.%s.`%s` where position_id = 16 and isFTE = true", "employee", "empinfo");
        this.runMongoSQLVerifyCount(queryString, 4);
    }

    @Test
    public void testResultCount() throws Exception {
        String queryString = String.format("select `employee_id` from mongo.%s.`%s` where (position_id = 16 and isFTE = true) or last_name = 'Yonce'", "employee", "empinfo");
        this.runMongoSQLVerifyCount(queryString, 5);
    }

    @Test
    public void testUnShardedDBInShardedCluster() throws Exception {
        String queryString = String.format("select * from mongo.%s.`%s`", "donuts", "donuts");
        this.runMongoSQLVerifyCount(queryString, 5);
    }

    @Test
    public void testEmptyCollection() throws Exception {
        String queryString = String.format("select * from mongo.%s.`%s`", "employee", "empty");
        this.runMongoSQLVerifyCount(queryString, 0);
    }

    @Test
    public void testUnShardedDBInShardedClusterWithProjectionAndFilter() throws Exception {
        String queryString = String.format("select t.name as name,t.topping.type as type from mongo.%s.`%s` t where t.sales >= 150", "donuts", "donuts");
        this.runMongoSQLVerifyCount(queryString, 2);
    }

    @Test
    public void testUnShardedDBInShardedClusterWithGroupByProjectionAndFilter() throws Exception {
        String queryString = String.format("select t.topping.type as type,count(t.topping.type) as typeCount from mongo.%s.`%s` t group by t.topping.type order by typeCount", "donuts", "donuts");
        this.runMongoSQLVerifyCount(queryString, 5);
    }

    @Test
    public void testPhysicalPlanSubmission() throws Exception {
        String query = String.format("select `employee_id` from mongo.%s.`%s` where isFTE = true", "employee", "empinfo");
        TestMongoQueries.testPhysicalPlanExecutionBasedOnQuery((String)query);
    }
}

