/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import org.apache.drill.categories.MongoStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.mongo.MongoTestBase;
import org.apache.drill.test.TestBuilder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Ignore(value="DRILL-3775")
@Category(value={SlowTest.class, MongoStorageTest.class})
public class TestMongoProjectPushDown
extends MongoTestBase {
    @Test
    public void testComplexProjectPushdown() throws Exception {
        try {
            TestMongoProjectPushDown.testBuilder().sqlQuery("select t.field_4.inner_3 as col_1, t.field_4 as col_2 from mongo.employee.schema_change t").unOrdered().optionSettingQueriesForTestQuery(String.format("alter session set `%s` = true", "store.mongo.read_numbers_as_double")).baselineColumns(new String[]{"col_1", "col_2"}).baselineValues(new Object[]{TestBuilder.mapOf((Object[])new Object[0]), TestBuilder.mapOf((Object[])new Object[]{"inner_1", TestBuilder.listOf((Object[])new Object[0]), "inner_3", TestBuilder.mapOf((Object[])new Object[0])})}).baselineValues(new Object[]{TestBuilder.mapOf((Object[])new Object[]{"inner_object_field_1", 2.0}), TestBuilder.mapOf((Object[])new Object[]{"inner_1", TestBuilder.listOf((Object[])new Object[]{1.0, 2.0, 3.0}), "inner_2", 3.0, "inner_3", TestBuilder.mapOf((Object[])new Object[]{"inner_object_field_1", 2.0})})}).baselineValues(new Object[]{TestBuilder.mapOf((Object[])new Object[0]), TestBuilder.mapOf((Object[])new Object[]{"inner_1", TestBuilder.listOf((Object[])new Object[]{4.0, 5.0, 6.0}), "inner_2", 3.0, "inner_3", TestBuilder.mapOf((Object[])new Object[0])})}).go();
        }
        catch (Throwable throwable) {
            TestMongoProjectPushDown.test((String)String.format("alter session set `%s` = false", "store.mongo.read_numbers_as_double"));
            throw throwable;
        }
        TestMongoProjectPushDown.test((String)String.format("alter session set `%s` = false", "store.mongo.read_numbers_as_double"));
    }

    @Test
    public void testSingleColumnProject() throws Exception {
        String query = String.format("SELECT `employee_id` FROM mongo.%s.`%s`", "employee", "empinfo");
        String expectedColNames = " \"columns\" : [ \"`employee_id`\" ]";
        this.testHelper(query, expectedColNames, 19);
    }

    @Test
    public void testMultipleColumnsProject() throws Exception {
        String query = String.format("select `employee_id`, `rating` from mongo.%s.`%s`", "employee", "empinfo");
        String expectedColNames = "\"columns\" : [ \"`employee_id`\", \"`rating`\" ]";
        this.testHelper(query, expectedColNames, 19);
    }

    @Test
    public void testStarProject() throws Exception {
        String query = String.format("select * from mongo.%s.`%s`", "employee", "empinfo");
        String expectedColNames = "*";
        this.testHelper(query, expectedColNames, 19);
    }
}

