/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.IMongosConfig;
import de.flapdoodle.embed.mongo.config.MongoCmdOptionsBuilder;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.MongosConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.mongo.tests.MongosSystemForTestFactory;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.categories.MongoStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.mongo.MongoTestConstants;
import org.apache.drill.exec.store.mongo.TestMongoChunkAssignment;
import org.apache.drill.exec.store.mongo.TestMongoFilterPushDown;
import org.apache.drill.exec.store.mongo.TestMongoProjectPushDown;
import org.apache.drill.exec.store.mongo.TestMongoQueries;
import org.apache.drill.exec.store.mongo.TestTableGenerator;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.bson.conversions.Bson;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={TestMongoFilterPushDown.class, TestMongoProjectPushDown.class, TestMongoQueries.class, TestMongoChunkAssignment.class})
@Category(value={SlowTest.class, MongoStorageTest.class})
public class MongoTestSuit
implements MongoTestConstants {
    private static final Logger logger = LoggerFactory.getLogger(MongoTestSuit.class);
    protected static MongoClient mongoClient;
    private static boolean distMode;
    private static boolean authEnabled;
    private static volatile AtomicInteger initCount;
    private static volatile boolean runningSuite;

    public static boolean isRunningSuite() {
        return runningSuite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void initMongo() throws Exception {
        Class<MongoTestSuit> clazz = MongoTestSuit.class;
        synchronized (MongoTestSuit.class) {
            if (initCount.get() == 0) {
                if (distMode) {
                    logger.info("Executing tests in distributed mode");
                    DistributedMode.setup();
                } else {
                    logger.info("Executing tests in single mode");
                    SingleMode.setup();
                }
                TestTableGenerator.importData("employee", "empinfo", "emp.json");
                TestTableGenerator.importData("employee", "schema_change", "schema_change_int_to_string.json");
                TestTableGenerator.importData("donuts", "donuts", "donuts.json");
                TestTableGenerator.importData("datatype", "types", "datatype-oid.json");
            }
            initCount.incrementAndGet();
            runningSuite = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void createDbAndCollections(String dbName, String collectionName, String indexFieldName) {
        MongoDatabase db = mongoClient.getDatabase(dbName);
        MongoCollection mongoCollection = db.getCollection(collectionName);
        if (mongoCollection == null) {
            db.createCollection(collectionName);
            mongoCollection = db.getCollection(collectionName);
        }
        if (indexFieldName.equals("_id")) {
            return;
        }
        IndexOptions indexOptions = new IndexOptions().unique(true).background(false).name(indexFieldName);
        Bson keys = Indexes.ascending((String[])new String[]{indexFieldName});
        mongoCollection.createIndex(keys, indexOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownCluster() throws Exception {
        Class<MongoTestSuit> clazz = MongoTestSuit.class;
        synchronized (MongoTestSuit.class) {
            if (initCount.decrementAndGet() == 0) {
                try {
                    if (mongoClient != null) {
                        mongoClient.dropDatabase("employee");
                        mongoClient.dropDatabase("datatype");
                        mongoClient.dropDatabase("donuts");
                    }
                }
                finally {
                    runningSuite = false;
                    if (mongoClient != null) {
                        mongoClient.close();
                    }
                    if (distMode) {
                        DistributedMode.cleanup();
                    } else {
                        SingleMode.cleanup();
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        distMode = System.getProperty("drill.mongo.tests.shardMode", "true").equalsIgnoreCase("true");
        authEnabled = System.getProperty("drill.mongo.tests.authEnabled", "false").equalsIgnoreCase("true");
        initCount = new AtomicInteger(0);
        runningSuite = false;
    }

    private static class SingleMode {
        private static MongodExecutable mongodExecutable;
        private static MongodProcess mongod;

        private SingleMode() {
        }

        private static void setup() throws UnknownHostException, IOException {
            IMongoCmdOptions cmdOptions = new MongoCmdOptionsBuilder().verbose(false).enableAuth(authEnabled).build();
            IMongodConfig mongodConfig = new MongodConfigBuilder().version((IFeatureAwareVersion)Version.Main.V3_4).net(new Net("localhost", 27017, Network.localhostIsIPv6())).cmdOptions(cmdOptions).build();
            IRuntimeConfig runtimeConfig = new RuntimeConfigBuilder().defaults(Command.MongoD).build();
            mongodExecutable = (MongodExecutable)MongodStarter.getInstance((IRuntimeConfig)runtimeConfig).prepare((IExecutableProcessConfig)mongodConfig);
            mongod = (MongodProcess)mongodExecutable.start();
            mongoClient = new MongoClient(new ServerAddress("localhost", 27017));
            MongoTestSuit.createDbAndCollections("employee", "empinfo", "employee_id");
            MongoTestSuit.createDbAndCollections("employee", "schema_change", "field_2");
            MongoTestSuit.createDbAndCollections("employee", "empty", "field_2");
            MongoTestSuit.createDbAndCollections("datatype", "types", "_id");
        }

        private static void cleanup() {
            if (mongod != null) {
                mongod.stop();
            }
            if (mongodExecutable != null) {
                mongodExecutable.stop();
            }
        }
    }

    private static class DistributedMode {
        private static MongosSystemForTestFactory mongosTestFactory;

        private DistributedMode() {
        }

        private static void setup() throws Exception {
            ArrayList<IMongodConfig> configServers = new ArrayList<IMongodConfig>(1);
            configServers.add(DistributedMode.crateConfigServerConfig(61114));
            configServers.add(DistributedMode.crateConfigServerConfig(61215));
            configServers.add(DistributedMode.crateConfigServerConfig(61316));
            LinkedHashMap replicaSets = new LinkedHashMap();
            ArrayList<IMongodConfig> replicaSet1 = new ArrayList<IMongodConfig>();
            replicaSet1.add(DistributedMode.crateIMongodConfig(27020, false, "shard_1_replicas"));
            replicaSet1.add(DistributedMode.crateIMongodConfig(27021, false, "shard_1_replicas"));
            replicaSet1.add(DistributedMode.crateIMongodConfig(27022, false, "shard_1_replicas"));
            ArrayList<IMongodConfig> replicaSet2 = new ArrayList<IMongodConfig>();
            replicaSet2.add(DistributedMode.crateIMongodConfig(27023, false, "shard_2_replicas"));
            replicaSet2.add(DistributedMode.crateIMongodConfig(27024, false, "shard_2_replicas"));
            replicaSet2.add(DistributedMode.crateIMongodConfig(27025, false, "shard_2_replicas"));
            replicaSets.put("config_replicas", configServers);
            replicaSets.put("shard_1_replicas", replicaSet1);
            replicaSets.put("shard_2_replicas", replicaSet2);
            IMongosConfig mongosConfig = DistributedMode.createIMongosConfig();
            mongosTestFactory = new MongosSystemForTestFactory(mongosConfig, replicaSets, (List)Lists.newArrayList(), "employee", "empinfo", "employee_id");
            try {
                mongosTestFactory.start();
                mongoClient = (MongoClient)mongosTestFactory.getMongo();
            }
            catch (Throwable e) {
                logger.error(" Error while starting shrded cluster. ", e);
                throw new Exception(" Error while starting shrded cluster. ", e);
            }
            MongoTestSuit.createDbAndCollections("donuts", "donuts", "id");
            MongoTestSuit.createDbAndCollections("employee", "empty", "field_2");
            MongoTestSuit.createDbAndCollections("datatype", "types", "_id");
        }

        private static IMongodConfig crateConfigServerConfig(int configServerPort) throws UnknownHostException, IOException {
            IMongoCmdOptions cmdOptions = new MongoCmdOptionsBuilder().useNoPrealloc(false).useSmallFiles(false).useNoJournal(false).useStorageEngine("wiredTiger").verbose(false).build();
            Storage replication = new Storage(null, "config_replicas", 0);
            IMongodConfig mongodConfig = new MongodConfigBuilder().version((IFeatureAwareVersion)Version.Main.V3_4).net(new Net("localhost", configServerPort, Network.localhostIsIPv6())).replication(replication).shardServer(false).configServer(true).cmdOptions(cmdOptions).build();
            return mongodConfig;
        }

        private static IMongodConfig crateIMongodConfig(int mongodPort, boolean flag, String replicaName) throws UnknownHostException, IOException {
            IMongoCmdOptions cmdOptions = new MongoCmdOptionsBuilder().useNoPrealloc(false).useSmallFiles(false).useNoJournal(false).useStorageEngine("wiredTiger").verbose(false).build();
            Storage replication = new Storage(null, replicaName, 0);
            IMongodConfig mongodConfig = new MongodConfigBuilder().version((IFeatureAwareVersion)Version.Main.V3_4).shardServer(true).net(new Net("localhost", mongodPort, Network.localhostIsIPv6())).configServer(flag).replication(replication).cmdOptions(cmdOptions).build();
            return mongodConfig;
        }

        private static IMongosConfig createIMongosConfig() throws UnknownHostException, IOException {
            IMongoCmdOptions cmdOptions = new MongoCmdOptionsBuilder().useNoPrealloc(false).useSmallFiles(false).useNoJournal(false).useStorageEngine("wiredTiger").verbose(false).build();
            IMongosConfig mongosConfig = new MongosConfigBuilder().version((IFeatureAwareVersion)Version.Main.V3_4).net(new Net("localhost", 27017, Network.localhostIsIPv6())).replicaSet("config_replicas").configDB("localhost:61114").cmdOptions(cmdOptions).build();
            return mongosConfig;
        }

        private static void cleanup() {
            if (mongosTestFactory != null) {
                try {
                    mongosTestFactory.stop();
                }
                catch (IllegalStateException e) {
                    logger.warn("Failed to close all mongod processes during provided timeout", (Throwable)e);
                }
            }
        }
    }
}

