/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import java.util.List;
import org.apache.drill.PlanTestBase;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.mongo.MongoStoragePlugin;
import org.apache.drill.exec.store.mongo.MongoStoragePluginConfig;
import org.apache.drill.exec.store.mongo.MongoTestConstants;
import org.apache.drill.exec.store.mongo.MongoTestSuit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;

public class MongoTestBase
extends PlanTestBase
implements MongoTestConstants {
    protected static MongoStoragePlugin storagePlugin;
    protected static MongoStoragePluginConfig storagePluginConfig;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Assume.assumeTrue((boolean)MongoTestSuit.isRunningSuite());
        MongoTestSuit.initMongo();
        MongoTestBase.initMongoStoragePlugin();
    }

    public static void initMongoStoragePlugin() throws Exception {
        StoragePluginRegistry pluginRegistry = MongoTestBase.getDrillbitContext().getStorage();
        storagePlugin = (MongoStoragePlugin)pluginRegistry.getPlugin("mongo");
        storagePluginConfig = storagePlugin.getConfig();
        storagePluginConfig.setEnabled(Boolean.valueOf(true));
        pluginRegistry.createOrUpdate("mongo", (StoragePluginConfig)storagePluginConfig, true);
        if (System.getProperty("drill.mongo.tests.bson.reader", "true").equalsIgnoreCase("false")) {
            MongoTestBase.testNoResult((String)String.format("alter session set `%s` = false", "store.mongo.bson.record.reader"), (Object[])new Object[0]);
        } else {
            MongoTestBase.testNoResult((String)String.format("alter session set `%s` = true", "store.mongo.bson.record.reader"), (Object[])new Object[0]);
        }
    }

    public List<QueryDataBatch> runMongoSQLWithResults(String sql) throws Exception {
        return MongoTestBase.testSqlWithResults((String)sql);
    }

    public void runMongoSQLVerifyCount(String sql, int expectedRowCount) throws Exception {
        List<QueryDataBatch> results = this.runMongoSQLWithResults(sql);
        this.logResultAndVerifyRowCount(results, expectedRowCount);
    }

    public void logResultAndVerifyRowCount(List<QueryDataBatch> results, int expectedRowCount) throws SchemaChangeException {
        int rowCount = this.logResult(results);
        if (expectedRowCount != -1) {
            Assert.assertEquals((long)expectedRowCount, (long)rowCount);
        }
    }

    public void testHelper(String query, String expectedExprInPlan, int expectedRecordCount) throws Exception {
        MongoTestBase.testPhysicalPlan((String)query, (String[])new String[]{expectedExprInPlan});
        int actualRecordCount = MongoTestBase.testSql((String)query);
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
    }

    @AfterClass
    public static void tearDownMongoTestBase() throws Exception {
        MongoTestSuit.tearDownCluster();
        storagePlugin = null;
    }
}

