/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import java.io.IOException;
import org.apache.drill.exec.exception.StoreException;
import org.apache.drill.exec.store.mongo.config.MongoPersistentStore;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;
import org.apache.drill.exec.store.sys.PersistentStoreRegistry;
import org.apache.drill.exec.store.sys.store.provider.BasePersistentStoreProvider;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoPersistentStoreProvider
extends BasePersistentStoreProvider {
    private static final Logger logger = LoggerFactory.getLogger(MongoPersistentStoreProvider.class);
    static final String pKey = "pKey";
    private MongoClient client;
    private MongoCollection<Document> collection;
    private final String mongoURL;

    public MongoPersistentStoreProvider(PersistentStoreRegistry registry) throws StoreException {
        this.mongoURL = registry.getConfig().getString("drill.exec.sys.store.provider.mongo.url");
    }

    public void start() throws IOException {
        MongoClientURI clientURI = new MongoClientURI(this.mongoURL);
        this.client = new MongoClient(clientURI);
        MongoDatabase db = this.client.getDatabase(clientURI.getDatabase());
        this.collection = db.getCollection(clientURI.getCollection()).withWriteConcern(WriteConcern.JOURNALED);
        Bson index = Indexes.ascending((String[])new String[]{pKey});
        this.collection.createIndex(index);
    }

    public <V> PersistentStore<V> getOrCreateStore(PersistentStoreConfig<V> config) {
        switch (config.getMode()) {
            case BLOB_PERSISTENT: 
            case PERSISTENT: {
                return new MongoPersistentStore<V>(config, this.collection);
            }
        }
        throw new IllegalStateException();
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

