/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.mongo.MongoCnxnKey;
import org.apache.drill.exec.store.mongo.MongoGroupScan;
import org.apache.drill.exec.store.mongo.MongoPushDownFilterForScan;
import org.apache.drill.exec.store.mongo.MongoScanSpec;
import org.apache.drill.exec.store.mongo.MongoStoragePluginConfig;
import org.apache.drill.exec.store.mongo.schema.MongoSchemaFactory;
import org.apache.drill.shaded.guava.com.google.common.cache.Cache;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheBuilder;
import org.apache.drill.shaded.guava.com.google.common.cache.RemovalListener;
import org.apache.drill.shaded.guava.com.google.common.cache.RemovalNotification;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStoragePlugin
extends AbstractStoragePlugin {
    static final Logger logger = LoggerFactory.getLogger(MongoStoragePlugin.class);
    private final MongoStoragePluginConfig mongoConfig;
    private final MongoSchemaFactory schemaFactory;
    private final Cache<MongoCnxnKey, MongoClient> addressClientMap;
    private final MongoClientURI clientURI;

    public MongoStoragePlugin(MongoStoragePluginConfig mongoConfig, DrillbitContext context, String name) throws IOException, ExecutionSetupException {
        super(context, name);
        this.mongoConfig = mongoConfig;
        this.clientURI = new MongoClientURI(this.mongoConfig.getConnection());
        this.addressClientMap = CacheBuilder.newBuilder().expireAfterAccess(24L, TimeUnit.HOURS).removalListener((RemovalListener)new AddressCloser()).build();
        this.schemaFactory = new MongoSchemaFactory(this, name);
    }

    public MongoStoragePluginConfig getConfig() {
        return this.mongoConfig;
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        this.schemaFactory.registerSchemas(schemaConfig, parent);
    }

    public boolean supportsRead() {
        return true;
    }

    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection) throws IOException {
        MongoScanSpec mongoScanSpec = (MongoScanSpec)selection.getListWith(new ObjectMapper(), (TypeReference)new TypeReference<MongoScanSpec>(){});
        return new MongoGroupScan(userName, this, mongoScanSpec, null);
    }

    public Set<StoragePluginOptimizerRule> getPhysicalOptimizerRules(OptimizerRulesContext optimizerRulesContext) {
        return ImmutableSet.of((Object)MongoPushDownFilterForScan.INSTANCE);
    }

    public MongoClient getClient(String host) {
        return this.getClient(Collections.singletonList(new ServerAddress(host)));
    }

    public MongoClient getClient() {
        List hosts = this.clientURI.getHosts();
        ArrayList addresses = Lists.newArrayList();
        for (String host : hosts) {
            addresses.add(new ServerAddress(host));
        }
        return this.getClient(addresses);
    }

    public synchronized MongoClient getClient(List<ServerAddress> addresses) {
        MongoCredential credential;
        String userName;
        ServerAddress serverAddress = addresses.get(0);
        MongoCnxnKey key = new MongoCnxnKey(serverAddress, userName = (credential = this.clientURI.getCredentials()) == null ? null : credential.getUserName());
        MongoClient client = (MongoClient)this.addressClientMap.getIfPresent((Object)key);
        if (client == null) {
            if (credential != null) {
                List<MongoCredential> credentialList = Arrays.asList(credential);
                client = new MongoClient(addresses, credentialList, this.clientURI.getOptions());
            } else {
                client = new MongoClient(addresses, this.clientURI.getOptions());
            }
            this.addressClientMap.put((Object)key, (Object)client);
            logger.debug("Created connection to {}.", (Object)key.toString());
            logger.debug("Number of open connections {}.", (Object)this.addressClientMap.size());
        }
        return client;
    }

    public void close() throws Exception {
        this.addressClientMap.invalidateAll();
    }

    private class AddressCloser
    implements RemovalListener<MongoCnxnKey, MongoClient> {
        private AddressCloser() {
        }

        public synchronized void onRemoval(RemovalNotification<MongoCnxnKey, MongoClient> removal) {
            ((MongoClient)removal.getValue()).close();
            logger.debug("Closed connection to {}.", (Object)((MongoCnxnKey)removal.getKey()).toString());
        }
    }
}

