/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import org.apache.drill.categories.MongoStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.mongo.MongoTestBase;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, MongoStorageTest.class})
public class TestMongoFilterPushDown
extends MongoTestBase {
    @Test
    public void testFilterPushDownIsEqual() throws Exception {
        String queryString = String.format("SELECT `full_name` FROM mongo.%s.`%s` where rating = 52.17", "employee", "empinfo");
        String expectedExpr = "\"$eq\" : 52.17";
        this.testHelper(queryString, expectedExpr, 1);
    }

    @Test
    public void testFilterPushDownLessThanWithSingleField() throws Exception {
        String queryString = String.format("SELECT `full_name` FROM mongo.%s.`%s` where rating < 52.17", "employee", "empinfo");
        String expectedExpr = "\"$lt\" : 52.17";
        this.testHelper(queryString, expectedExpr, 9);
    }

    @Test
    public void testFilterPushDownGreaterThanWithSingleField() throws Exception {
        String queryString = String.format("SELECT `full_name` FROM mongo.%s.`%s` where rating > 52.17", "employee", "empinfo");
        String expectedExpr = "\"$gt\" : 52.17";
        this.testHelper(queryString, expectedExpr, 9);
    }
}

