/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.List;
import org.apache.drill.StringChanger;
import org.apache.drill.logback.MaskingPatternLayout;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedConstruction;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.MDC;

public class MaskingPatternLayoutTest {
    @Test
    public void shouldUseMDCForUserName() {
        MockedConstruction stringChangerConstruction = Mockito.mockConstruction(StringChanger.class);
        ILoggingEvent eventMock = (ILoggingEvent)Mockito.mock(ILoggingEvent.class);
        MaskingPatternLayout cut = new MaskingPatternLayout();
        cut.setRulesConfig("/some/path");
        String mdcKey = "drill.userName";
        String givenUserName = "testUser";
        String expectedUserName = new String("testUser");
        MockedStatic mdcMocked = Mockito.mockStatic(MDC.class);
        mdcMocked.when(() -> MDC.get((String)"drill.userName")).thenReturn((Object)"testUser");
        cut.doLayout(eventMock);
        List stringChangerMocks = stringChangerConstruction.constructed();
        Assertions.assertEquals((int)1, (int)stringChangerMocks.size(), (String)(MaskingPatternLayout.class.getName() + " should construct only one " + StringChanger.class.getName()));
        ((StringChanger)Mockito.verify((Object)((StringChanger)stringChangerMocks.get(0)), (VerificationMode)Mockito.times((int)1))).changeString(ArgumentMatchers.anyString(), (String)Mockito.eq((Object)expectedUserName));
        mdcMocked.verify(() -> MDC.get((String)"drill.userName"), Mockito.times((int)1));
        stringChangerConstruction.close();
        mdcMocked.close();
    }
}

