/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kudu;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractWriter;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.kudu.KuduStoragePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduWriter
extends AbstractWriter {
    static final Logger logger = LoggerFactory.getLogger(KuduWriter.class);
    private final KuduStoragePlugin plugin;
    private final String name;

    @JsonCreator
    public KuduWriter(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="name") String name, @JsonProperty(value="storage") StoragePluginConfig storageConfig, @JacksonInject StoragePluginRegistry engineRegistry) throws IOException, ExecutionSetupException {
        super(child);
        this.plugin = (KuduStoragePlugin)engineRegistry.getPlugin(storageConfig);
        this.name = name;
    }

    KuduWriter(PhysicalOperator child, String name, KuduStoragePlugin plugin) {
        super(child);
        this.name = name;
        this.plugin = plugin;
    }

    public int getOperatorType() {
        return 48;
    }

    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new KuduWriter(child, this.name, this.plugin);
    }

    public String getName() {
        return this.name;
    }

    public StoragePluginConfig getStorage() {
        return this.plugin.getConfig();
    }

    @JsonIgnore
    public KuduStoragePlugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return "KuduWriter[name=" + this.name + ", storageStrategy=" + this.getStorageStrategy() + "]";
    }
}

