/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kudu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.store.kudu.KuduRecordWriter;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.SessionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduRecordWriterImpl
extends KuduRecordWriter {
    static final Logger logger = LoggerFactory.getLogger(KuduRecordWriterImpl.class);
    private static final int FLUSH_FREQUENCY = 100;
    private final KuduClient client;
    private final String name;
    private final OperatorContext context;
    private KuduTable table;
    private KuduSession session;
    private Insert insert;
    private int recordsSinceFlush;

    public KuduRecordWriterImpl(OperatorContext context, KuduClient client, String name) {
        this.client = client;
        this.name = name;
        this.context = context;
        this.session = client.newSession();
        this.session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
    }

    public void init(Map<String, String> writerOptions) throws IOException {
    }

    public void updateSchema(VectorAccessible batch) throws IOException {
        BatchSchema schema = batch.getSchema();
        int i = 0;
        try {
            if (!this.checkForTable(this.name)) {
                ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
                for (MaterializedField f : schema) {
                    columns.add(new ColumnSchema.ColumnSchemaBuilder(f.getName(), this.getType(f.getType())).nullable(f.getType().getMode() == TypeProtos.DataMode.OPTIONAL).key(i == 0).build());
                    ++i;
                }
                Schema kuduSchema = new Schema(columns);
                this.table = this.client.createTable(this.name, kuduSchema, new CreateTableOptions());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private boolean checkForTable(String name) throws Exception {
        return !this.client.getTablesList(name).getTablesList().isEmpty();
    }

    private Type getType(TypeProtos.MajorType t) {
        if (t.getMode() == TypeProtos.DataMode.REPEATED) {
            throw UserException.dataWriteError().message("Kudu does not support array types.", new Object[0]).build(logger);
        }
        switch (t.getMinorType()) {
            case BIGINT: {
                return Type.INT64;
            }
            case BIT: {
                return Type.BOOL;
            }
            case FLOAT4: {
                return Type.FLOAT;
            }
            case FLOAT8: {
                return Type.DOUBLE;
            }
            case INT: {
                return Type.INT32;
            }
            case TIMESTAMP: {
                return Type.UNIXTIME_MICROS;
            }
            case VARCHAR: {
                return Type.STRING;
            }
            case VARBINARY: {
                return Type.BINARY;
            }
        }
        throw UserException.dataWriteError().message("Data type: '%s' not supported in Kudu.", new Object[]{t.getMinorType().name()}).build(logger);
    }

    public void startRecord() throws IOException {
        this.insert = this.table.newInsert();
        this.setUp(this.insert.getRow());
    }

    public void endRecord() throws IOException {
        try {
            this.session.apply((Operation)this.insert);
            ++this.recordsSinceFlush;
            if (this.recordsSinceFlush == 100) {
                this.flush();
                this.recordsSinceFlush = 0;
            }
            this.insert = null;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void abort() throws IOException {
    }

    private void flush() throws IOException {
        try {
            List responses = this.session.flush();
            for (OperationResponse response : responses) {
                if (!response.hasRowError()) continue;
                throw new IOException(response.getRowError().toString());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void cleanup() throws IOException {
        this.flush();
    }
}

