/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.util.HashMap;
import org.apache.drill.categories.JdbcStorageTest;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.test.ClientFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.jdbc.JdbcDatabaseDelegate;
import org.testcontainers.utility.DockerImageName;

@Category(value={JdbcStorageTest.class})
public class TestJdbcUserTranslation
extends ClusterTest {
    private static final String DOCKER_IMAGE_MYSQL = "mysql:5.7.27";
    private static final String DOCKER_IMAGE_MARIADB = "mariadb:10.6.0";
    private static JdbcDatabaseContainer<?> jdbcContainer;
    private static final String PLUGIN_NAME = "mysql";

    @BeforeClass
    public static void initMysql() throws Exception {
        ClusterFixtureBuilder builder = new ClusterFixtureBuilder(dirTestWatcher).configProperty("drill.exec.http.enabled", (Object)true).configProperty("drill.exec.http.porthunt", (Object)true).configProperty("drill.exec.security.user.auth.impl", (Object)"drillTestAuthenticator").configProperty("drill.exec.impersonation.enabled", (Object)true);
        TestJdbcUserTranslation.startCluster((ClusterFixtureBuilder)builder);
        String osName = System.getProperty("os.name").toLowerCase();
        String mysqlDBName = "drill_mysql_test";
        DockerImageName imageName = osName.startsWith("linux") && "aarch64".equals(System.getProperty("os.arch")) ? DockerImageName.parse((String)DOCKER_IMAGE_MARIADB).asCompatibleSubstituteFor(PLUGIN_NAME) : DockerImageName.parse((String)DOCKER_IMAGE_MYSQL);
        jdbcContainer = ((MySQLContainer)((MySQLContainer)((MySQLContainer)new MySQLContainer(imageName).withExposedPorts(new Integer[]{3306})).withConfigurationOverride("mysql_config_override").withUsername("mysqlUser").withPassword("mysqlPass").withDatabaseName(mysqlDBName).withUrlParam("serverTimezone", "UTC")).withUrlParam("useJDBCCompliantTimezoneShift", "true")).withInitScript("mysql-test-data.sql");
        jdbcContainer.start();
        if (osName.startsWith("linux")) {
            JdbcDatabaseDelegate databaseDelegate = new JdbcDatabaseDelegate(jdbcContainer, "");
            ScriptUtils.runInitScript((DatabaseDelegate)databaseDelegate, (String)"mysql-test-data-linux.sql");
        }
        PlainCredentialsProvider credentialsProvider = new PlainCredentialsProvider(new HashMap());
        String jdbcUrl = jdbcContainer.getJdbcUrl();
        JdbcStorageConfig jdbcStorageConfig = new JdbcStorageConfig("com.mysql.cj.jdbc.Driver", jdbcUrl, jdbcContainer.getUsername(), jdbcContainer.getPassword(), false, false, null, (CredentialsProvider)credentialsProvider, "user_translation", 10000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin(PLUGIN_NAME, (StoragePluginConfig)jdbcStorageConfig);
    }

    @AfterClass
    public static void stopMysql() {
        if (jdbcContainer != null) {
            jdbcContainer.stop();
        }
    }

    @Test
    public void testShowDatabasesWithUserWithNoCreds() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser2").property("password", (Object)"testUser2Password").build();
        String sql = "SHOW DATABASES";
        QueryBuilder.QuerySummary results = client.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)results.succeeded());
        Assert.assertEquals((long)results.recordCount(), (long)7L);
    }

    @Test
    public void testShowDatabasesWithUserWithValidCreds() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser1").property("password", (Object)"testUser1Password").build();
        JdbcStorageConfig pluginConfig = (JdbcStorageConfig)cluster.storageRegistry().getPlugin(PLUGIN_NAME).getConfig();
        PlainCredentialsProvider credentialProvider = (PlainCredentialsProvider)pluginConfig.getCredentialsProvider();
        credentialProvider.setUserCredentials("mysqlUser", "mysqlPass", "testUser1");
        pluginConfig.updateCredentialProvider((CredentialsProvider)credentialProvider);
        String sql = "SHOW DATABASES";
        QueryBuilder.QuerySummary results = client.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)results.succeeded());
        Assert.assertEquals((long)10L, (long)results.recordCount());
    }

    @Test
    public void testQueryWithInvalidCredentials() {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser2").property("password", (Object)"testUser2Password").build();
        String sql = "SELECT * FROM mysql.`drill_mysql_test`.person";
        try {
            client.queryBuilder().sql(sql).rowSet();
            Assert.fail();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Object 'mysql' not found"));
        }
    }

    @Test
    public void testQueryWithValidCredentials() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser1").property("password", (Object)"testUser1Password").build();
        JdbcStorageConfig pluginConfig = (JdbcStorageConfig)cluster.storageRegistry().getPlugin(PLUGIN_NAME).getConfig();
        PlainCredentialsProvider credentialProvider = (PlainCredentialsProvider)pluginConfig.getCredentialsProvider();
        credentialProvider.setUserCredentials("mysqlUser", "mysqlPass", "testUser1");
        pluginConfig.updateCredentialProvider((CredentialsProvider)credentialProvider);
        String sql = "SELECT first_name, last_name FROM mysql.`drill_mysql_test`.person";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("first_name", TypeProtos.MinorType.VARCHAR, 38).addNullable("last_name", TypeProtos.MinorType.VARCHAR, 38).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"first_name_1", "last_name_1"}).addRow(new Object[]{"first_name_2", "last_name_2"}).addRow(new Object[]{"first_name_3", "last_name_3"}).addRow(new Object[]{null, null}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }
}

