/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.drill.categories.JdbcStorageTest;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.jdbc.JdbcDatabaseDelegate;
import org.testcontainers.utility.DockerImageName;

@Category(value={JdbcStorageTest.class})
public class TestJdbcPluginWithMySQLIT
extends ClusterTest {
    private static final String DOCKER_IMAGE_MARIADB = "mariadb:10.6.0";
    private static JdbcDatabaseContainer<?> jdbcContainer;

    @BeforeClass
    public static void initMysql() throws Exception {
        TestJdbcPluginWithMySQLIT.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        String osName = System.getProperty("os.name").toLowerCase();
        String mysqlDBName = "drill_mysql_test";
        DockerImageName imageName = DockerImageName.parse((String)DOCKER_IMAGE_MARIADB).asCompatibleSubstituteFor("mysql");
        jdbcContainer = ((MySQLContainer)((MySQLContainer)((MySQLContainer)new MySQLContainer(imageName).withExposedPorts(new Integer[]{3306})).withConfigurationOverride("mysql_config_override").withUsername("mysqlUser").withPassword("mysqlPass").withDatabaseName(mysqlDBName).withUrlParam("serverTimezone", "UTC")).withUrlParam("useJDBCCompliantTimezoneShift", "true")).withInitScript("mysql-test-data.sql");
        jdbcContainer.start();
        if (osName.startsWith("linux")) {
            JdbcDatabaseDelegate databaseDelegate = new JdbcDatabaseDelegate(jdbcContainer, "");
            ScriptUtils.runInitScript((DatabaseDelegate)databaseDelegate, (String)"mysql-test-data-linux.sql");
        }
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", jdbcContainer.getUsername());
        credentials.put("password", jdbcContainer.getPassword());
        PlainCredentialsProvider credentialsProvider = new PlainCredentialsProvider(credentials);
        String jdbcUrl = jdbcContainer.getJdbcUrl();
        JdbcStorageConfig jdbcStorageConfig = new JdbcStorageConfig("com.mysql.cj.jdbc.Driver", jdbcUrl, null, null, false, false, null, (CredentialsProvider)credentialsProvider, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("mysql", (StoragePluginConfig)jdbcStorageConfig);
        if (osName.startsWith("linux")) {
            JdbcStorageConfig jdbcCaseSensitiveStorageConfig = new JdbcStorageConfig("com.mysql.cj.jdbc.Driver", jdbcUrl, null, null, true, false, null, (CredentialsProvider)credentialsProvider, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
            jdbcCaseSensitiveStorageConfig.setEnabled(Boolean.valueOf(true));
            cluster.defineStoragePlugin("mysqlCaseInsensitive", (StoragePluginConfig)jdbcCaseSensitiveStorageConfig);
        }
    }

    @AfterClass
    public static void stopMysql() {
        if (jdbcContainer != null) {
            jdbcContainer.stop();
        }
    }

    @Test
    public void validateResult() throws Exception {
        this.testBuilder().sqlQuery("select person_id, first_name, last_name, address, city, state, zip, bigint_field, smallint_field, numeric_field, boolean_field, double_field, float_field, real_field, date_field, datetime_field, year_field, time_field, json, text_field, tiny_text_field, medium_text_field, long_text_field, blob_field, bit_field, enum_field from mysql.`drill_mysql_test`.person").ordered().baselineColumns(new String[]{"person_id", "first_name", "last_name", "address", "city", "state", "zip", "bigint_field", "smallint_field", "numeric_field", "boolean_field", "double_field", "float_field", "real_field", "date_field", "datetime_field", "year_field", "time_field", "json", "text_field", "tiny_text_field", "medium_text_field", "long_text_field", "blob_field", "bit_field", "enum_field"}).baselineValues(new Object[]{1, "first_name_1", "last_name_1", "1401 John F Kennedy Blvd", "Philadelphia", "PA", 19107, 123456789L, 1, new BigDecimal("10.01"), false, 1.0, 1.1, 1.2, DateUtility.parseLocalDate((String)"2012-02-29"), DateUtility.parseLocalDateTime((String)"2012-02-29 13:00:01.0"), DateUtility.parseLocalDate((String)"2015-01-01"), DateUtility.parseLocalTime((String)"13:00:01.0"), "{ a : 5, b : 6 }", "It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout", "xxx", "a medium piece of text", "a longer piece of text this is going on.....", "this is a test".getBytes(StandardCharsets.UTF_8), true, "XXX"}).baselineValues(new Object[]{2, "first_name_2", "last_name_2", "One Ferry Building", "San Francisco", "CA", 94111, 45456767L, 3, new BigDecimal("30.04"), true, 3.0, 3.1, 3.2, DateUtility.parseLocalDate((String)"2011-10-30"), DateUtility.parseLocalDateTime((String)"2011-10-30 11:34:21.0"), DateUtility.parseLocalDate((String)"2015-01-01"), DateUtility.parseLocalTime((String)"11:34:21.0"), "{ z : [ 1, 2, 3 ] }", "It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout", "abc", "a medium piece of text 2", "somewhat more text", "this is a test 2".getBytes(StandardCharsets.UTF_8), false, "YYY"}).baselineValues(new Object[]{3, "first_name_3", "last_name_3", "176 Bowery", "New York", "NY", 10012, 123090L, -3, new BigDecimal("55.12"), false, 5.0, 5.1, 5.55, DateUtility.parseLocalDate((String)"2015-06-01"), DateUtility.parseLocalDateTime((String)"2015-09-22 15:46:10.0"), DateUtility.parseLocalDate((String)"1901-01-01"), DateUtility.parseLocalTime((String)"16:00:01.0"), "{ [ a, b, c ] }", "Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit", "abc", "a medium piece of text 3", "somewhat more text", "this is a test 3".getBytes(StandardCharsets.UTF_8), true, "ZZZ"}).baselineValues(new Object[]{5, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "XXX"}).go();
    }

    @Test
    public void pushDownJoin() throws Exception {
        String query = "select x.person_id from (select person_id from mysql.`drill_mysql_test`.person) x join (select person_id from mysql.`drill_mysql_test`.person) y on x.person_id = y.person_id";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Join"}).match();
    }

    @Test
    public void pushDownJoinAndFilterPushDown() throws Exception {
        String query = "select * from mysql.`drill_mysql_test`.person e INNER JOIN mysql.`drill_mysql_test`.person s ON e.first_name = s.first_name WHERE e.last_name > 'hello'";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Join", "Filter"}).match();
    }

    @Test
    public void pushDownAggWithDecimal() throws Exception {
        String query = "SELECT sum(decimal_field * smallint_field) AS `order_total`\nFROM mysql.`drill_mysql_test`.person e";
        DirectRowSet results = this.queryBuilder().sql(query).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("order_total", TypeProtos.MinorType.VARDECIMAL, 38, 2).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{123.32}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testPhysicalPlanSubmission() throws Exception {
        String query = "select * from mysql.`drill_mysql_test`.person";
        String plan = this.queryBuilder().sql(query).explainJson();
        Assert.assertEquals((long)4L, (long)this.queryBuilder().physical(plan).run().recordCount());
    }

    @Test
    public void emptyOutput() {
        String query = "select * from mysql.`drill_mysql_test`.person e limit 0";
        this.testBuilder().sqlQuery(query).expectsEmptyResultSet();
    }

    @Test
    public void testCaseSensitiveTableNames() throws Exception {
        String osName = System.getProperty("os.name").toLowerCase();
        Assume.assumeTrue((String)"Skip tests for non-linux systems due to table names case-insensitivity problems on Windows and MacOS", (boolean)osName.startsWith("linux"));
        TestJdbcPluginWithMySQLIT.run((String)"use mysqlCaseInsensitive.`drill_mysql_test`", (Object[])new Object[0]);
        Assert.assertEquals((long)2L, (long)this.queryBuilder().sql("show tables like 'caseSensitiveTable'").run().recordCount());
        TestJdbcPluginWithMySQLIT.run((String)"use mysql.`drill_mysql_test`", (Object[])new Object[0]);
        Assert.assertEquals((long)1L, (long)this.queryBuilder().sql("show tables like 'caseSensitiveTable'").run().recordCount());
        Assert.assertEquals((long)1L, (long)this.queryBuilder().sql("describe caseSensitiveTable").run().recordCount());
        Assert.assertEquals((long)2L, (long)this.queryBuilder().sql("describe CASESENSITIVETABLE").run().recordCount());
    }

    @Test
    public void testExpressionsWithoutAlias() throws Exception {
        String query = "select count(*), 1+1+2+3+5+8+13+21+34, (1+sqrt(5))/2\nfrom mysql.`drill_mysql_test`.person";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"EXPR$0", "EXPR$1", "EXPR$2"}).baselineValues(new Object[]{4L, 88, BigDecimal.valueOf(1.618033988749895)}).go();
    }

    @Test
    public void testExpressionsWithoutAliasesPermutations() throws Exception {
        String query = "select EXPR$1, EXPR$0, EXPR$2\nfrom (select 1+1+2+3+5+8+13+21+34, (1+sqrt(5))/2, count(*) from mysql.`drill_mysql_test`.person)";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"EXPR$1", "EXPR$0", "EXPR$2"}).baselineValues(new Object[]{BigDecimal.valueOf(1.618033988749895), 88, 4L}).go();
    }

    @Test
    public void testExpressionsWithAliases() throws Exception {
        String query = "select person_id as ID, 1+1+2+3+5+8+13+21+34 as FIBONACCI_SUM, (1+sqrt(5))/2 as golden_ratio\nfrom mysql.`drill_mysql_test`.person limit 2";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"ID", "FIBONACCI_SUM", "golden_ratio"}).baselineValues(new Object[]{1, 88, BigDecimal.valueOf(1.618033988749895)}).baselineValues(new Object[]{2, 88, BigDecimal.valueOf(1.618033988749895)}).go();
    }

    @Test
    public void testJoinStar() throws Exception {
        String query = "select * from (select person_id from mysql.`drill_mysql_test`.person) t1 join (select person_id from mysql.`drill_mysql_test`.person) t2 on t1.person_id = t2.person_id";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"person_id", "person_id0"}).baselineValues(new Object[]{1, 1}).baselineValues(new Object[]{2, 2}).baselineValues(new Object[]{3, 3}).baselineValues(new Object[]{5, 5}).go();
    }

    @Test
    public void testSemiJoin() throws Exception {
        String query = "select person_id from mysql.`drill_mysql_test`.person t1\nwhere exists (select person_id from mysql.`drill_mysql_test`.person\nwhere t1.person_id = person_id)";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"person_id"}).baselineValuesForSingleColumn(new Object[]{1, 2, 3, 5}).go();
    }

    @Test
    public void testInformationSchemaViews() throws Exception {
        String query = "select * from information_schema.`views`";
        TestJdbcPluginWithMySQLIT.run((String)query, (Object[])new Object[0]);
    }

    @Test
    public void testJdbcTableTypes() throws Exception {
        String query = "select distinct table_type from information_schema.`tables` where table_schema like 'mysql%'";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"table_type"}).baselineValuesForSingleColumn(new Object[]{"SYSTEM VIEW", "TABLE", "VIEW"}).go();
    }

    @Test
    public void testLimitPushDown() throws Exception {
        String query = "select person_id, first_name, last_name from mysql.`drill_mysql_test`.person limit 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*LIMIT 100"}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testLimitPushDownWithOrderBy() throws Exception {
        String query = "select person_id from mysql.`drill_mysql_test`.person order by first_name limit 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*ORDER BY `first_name`.*LIMIT 100"}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testLimitPushDownWithOffset() throws Exception {
        String query = "select person_id, first_name from mysql.`drill_mysql_test`.person limit 100 offset 10";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*LIMIT 100 OFFSET 10"}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testLimitPushDownWithConvertFromJson() throws Exception {
        String query = "select convert_fromJSON(first_name)['ppid'] from mysql.`drill_mysql_test`.person LIMIT 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*LIMIT 100"}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testParquetLimitWithSort() throws Exception {
        this.queryBuilder().sql("SELECT n_name\nFROM cp.`/tpch/nation.parquet`\nORDER BY n_name DESC\nLIMIT 1").planMatcher().include(new String[]{"Limit\\("}).match();
    }
}

