/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Map;
import java.util.TimeZone;
import org.apache.drill.categories.JdbcStorageTest;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.testcontainers.containers.MSSQLServerContainer;

@Category(value={JdbcStorageTest.class})
public class TestJdbcPluginWithMSSQL
extends ClusterTest {
    private static MSSQLServerContainer<?> jdbcContainer;

    @BeforeClass
    public static void initMSSQL() throws Exception {
        Assume.assumeTrue((boolean)System.getProperty("os.arch").matches("(amd64|x86_64)"));
        TestJdbcPluginWithMSSQL.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        jdbcContainer = ((MSSQLServerContainer)((MSSQLServerContainer)new MSSQLServerContainer().withPassword("B!llyG0atGruff").withInitScript("mssql-test-data.ms.sql")).withUrlParam("trustServerCertificate", "true")).acceptLicense();
        jdbcContainer.start();
        ImmutableMap credentials = ImmutableMap.builder().put((Object)"username", (Object)jdbcContainer.getUsername()).put((Object)"password", (Object)jdbcContainer.getPassword()).build();
        PlainCredentialsProvider credentialsProvider = new PlainCredentialsProvider((Map)credentials);
        ImmutableMap sourceParms = ImmutableMap.builder().put((Object)"connectionTestQuery", (Object)"select 1").build();
        JdbcStorageConfig jdbcStorageConfig = new JdbcStorageConfig("net.sourceforge.jtds.jdbc.Driver", jdbcContainer.getJdbcUrl().replaceFirst("jdbc:", "jdbc:jtds:"), null, null, true, false, (Map)sourceParms, (CredentialsProvider)credentialsProvider, StoragePluginConfig.AuthMode.SHARED_USER.name(), 100000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("mssql", (StoragePluginConfig)jdbcStorageConfig);
    }

    @AfterClass
    public static void stopMSSQL() {
        if (jdbcContainer != null) {
            jdbcContainer.stop();
        }
    }

    @Test
    public void validateResult() throws Exception {
        String sql = "SELECT person_id, first_name, last_name, address, city, state, zip, json, bigint_field, smallint_field, decimal_field, bit_field, double_field, float_field, datetime_field FROM mssql.dbo.person ORDER BY person_id";
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("person_id", TypeProtos.MinorType.INT, 10).addNullable("first_name", TypeProtos.MinorType.VARCHAR, 38).addNullable("last_name", TypeProtos.MinorType.VARCHAR, 38).addNullable("address", TypeProtos.MinorType.VARCHAR, 38).addNullable("city", TypeProtos.MinorType.VARCHAR, 38).addNullable("state", TypeProtos.MinorType.VARCHAR, 2).addNullable("zip", TypeProtos.MinorType.INT, 10).addNullable("json", TypeProtos.MinorType.VARCHAR, 38).addNullable("bigint_field", TypeProtos.MinorType.BIGINT, 19).addNullable("smallint_field", TypeProtos.MinorType.INT, 5).addNullable("decimal_field", TypeProtos.MinorType.VARDECIMAL, 15, 2).addNullable("bit_field", TypeProtos.MinorType.BIT, 1).addNullable("double_field", TypeProtos.MinorType.FLOAT8, 15).addNullable("float_field", TypeProtos.MinorType.FLOAT8, 15).addNullable("datetime_field", TypeProtos.MinorType.TIMESTAMP, 23, 3).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{1, "first_name_1", "last_name_1", "1401 John F Kennedy Blvd", "Philadelphia", "PA", 19107, "{ a : 5, b : 6 }", 123456789L, 1, new BigDecimal("123.32"), 1, 1.0, 1.1, 1330520401000L}).addRow(new Object[]{2, "first_name_2", "last_name_2", "One Ferry Building", "San Francisco", "CA", 94111, "{ z : [ 1, 2, 3 ] }", 45456767L, 3, null, 0, 3.0, 3.1, 1319974461000L}).addRow(new Object[]{3, "first_name_3", "last_name_3", "176 Bowery", "New York", "NY", 10012, "{ [ a, b, c ] }", 123090L, -3, null, 1, 5.0, 5.1, 1442936770000L}).addRow(new Object[]{4, null, null, null, null, null, null, null, null, null, null, null, null, null, null}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void pushDownJoin() throws Exception {
        String query = "select x.person_id from (select person_id from mssql.dbo.person) x join (select person_id from mssql.dbo.person) y on x.person_id = y.person_id";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Join"}).match();
    }

    @Test
    public void pushDownJoinAndFilterPushDown() throws Exception {
        String query = "select * from mssql.dbo.person e INNER JOIN mssql.dbo.person s ON e.first_name = s.first_name WHERE e.last_name > 'hello'";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Join", "Filter"}).match();
    }

    @Test
    public void testPhysicalPlanSubmission() throws Exception {
        String query = "select * from mssql.dbo.person";
        String plan = this.queryBuilder().sql(query).explainJson();
        Assert.assertEquals((long)4L, (long)this.queryBuilder().physical(plan).run().recordCount());
    }

    @Test
    public void emptyOutput() {
        String query = "select * from mssql.dbo.person e limit 0";
        this.testBuilder().sqlQuery(query).expectsEmptyResultSet();
    }

    @Test
    public void testExpressionsWithoutAlias() throws Exception {
        String sql = "select count(*), 1+1+2+3+5+8+13+21+34, (1+sqrt(5))/2\nfrom mssql.dbo.person";
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("EXPR$0", TypeProtos.MinorType.INT, 10).addNullable("EXPR$1", TypeProtos.MinorType.INT, 10).addNullable("EXPR$2", TypeProtos.MinorType.FLOAT8, 15).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{4L, 88L, 1.618033988749895}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testExpressionsWithoutAliasesPermutations() throws Exception {
        String query = "select EXPR$1, EXPR$0, EXPR$2\nfrom (select 1+1+2+3+5+8+13+21+34, (1+sqrt(5))/2, count(*) from mssql.dbo.person)";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"EXPR$1", "EXPR$0", "EXPR$2"}).baselineValues(new Object[]{1.618033988749895, 88, 4}).go();
    }

    @Test
    public void testExpressionsWithAliases() throws Exception {
        String query = "SELECT person_id AS ID, 1+1+2+3+5+8+13+21+34 as FIBONACCI_SUM, (1+sqrt(5))/2 as golden_ratio\nFROM mssql.dbo.person limit 2";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"ID", "FIBONACCI_SUM", "golden_ratio"}).baselineValues(new Object[]{1, 88, 1.618033988749895}).baselineValues(new Object[]{2, 88, 1.618033988749895}).go();
    }

    @Test
    public void testJoinStar() throws Exception {
        String query = "select * from (select person_id from mssql.dbo.person) t1 join (select person_id from mssql.dbo.person) t2 on t1.person_id = t2.person_id";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"person_id", "person_id0"}).baselineValues(new Object[]{1, 1}).baselineValues(new Object[]{2, 2}).baselineValues(new Object[]{3, 3}).baselineValues(new Object[]{4, 4}).go();
    }

    @Test
    public void testSemiJoin() throws Exception {
        String query = "select person_id from mssql.dbo.person t1\nwhere exists (select person_id from mssql.dbo.person\nwhere t1.person_id = person_id)";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"person_id"}).baselineValuesForSingleColumn(new Object[]{1, 2, 3, 4}).go();
    }

    @Test
    public void testInformationSchemaViews() throws Exception {
        String query = "select * from information_schema.`views`";
        TestJdbcPluginWithMSSQL.run((String)query, (Object[])new Object[0]);
    }

    @Test
    public void testJdbcTableTypes() throws Exception {
        String query = "select distinct table_type from information_schema.`tables` where table_schema like 'mssql%'";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"table_type"}).baselineValuesForSingleColumn(new Object[]{"TABLE", "VIEW"}).go();
    }

    @Test
    public void testLimitPushDown() throws Exception {
        String query = "select person_id, first_name, last_name from mssql.dbo.person limit 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*SELECT TOP \\(100\\)"}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testLimitPushDownWithOrderBy() throws Exception {
        String query = "select person_id from mssql.dbo.person order by first_name limit 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*SELECT TOP \\(100\\).*ORDER BY.*\"first_name\""}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testLimitPushDownWithOffset() throws Exception {
        String query = "select person_id, first_name from mssql.dbo.person limit 100 offset 10";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*SELECT TOP \\(110\\)"}).include(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testLimitPushDownWithConvertFromJson() throws Exception {
        String query = "select convert_fromJSON(first_name)['ppid'] from mssql.dbo.person LIMIT 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*SELECT TOP \\(100\\)"}).exclude(new String[]{"Limit\\("}).match();
    }
}

