/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.nio.file.Paths;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.drill.categories.JdbcStorageTest;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.jdbc.JdbcDatabaseDelegate;
import org.testcontainers.utility.DockerImageName;

@Category(value={JdbcStorageTest.class})
public class TestJdbcInsertWithMySQL
extends ClusterTest {
    private static final String DOCKER_IMAGE_MYSQL = "mysql:5.7.27";
    private static final String DOCKER_IMAGE_MARIADB = "mariadb:10.6.0";
    private static final Logger logger = LoggerFactory.getLogger(TestJdbcInsertWithMySQL.class);
    private static JdbcDatabaseContainer<?> jdbcContainer;

    @BeforeClass
    public static void initMysql() throws Exception {
        TestJdbcInsertWithMySQL.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        dirTestWatcher.copyResourceToRoot(Paths.get("", new String[0]));
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        String osName = System.getProperty("os.name").toLowerCase();
        String mysqlDBName = "drill_mysql_test";
        DockerImageName imageName = osName.startsWith("linux") && "aarch64".equals(System.getProperty("os.arch")) ? DockerImageName.parse((String)DOCKER_IMAGE_MARIADB).asCompatibleSubstituteFor("mysql") : DockerImageName.parse((String)DOCKER_IMAGE_MYSQL);
        jdbcContainer = ((MySQLContainer)((MySQLContainer)((MySQLContainer)new MySQLContainer(imageName).withExposedPorts(new Integer[]{3306})).withConfigurationOverride("mysql_config_override").withUsername("mysqlUser").withPassword("mysqlPass").withDatabaseName(mysqlDBName).withUrlParam("serverTimezone", "UTC")).withUrlParam("useJDBCCompliantTimezoneShift", "true")).withInitScript("mysql-test-data.sql");
        jdbcContainer.start();
        if (osName.startsWith("linux")) {
            JdbcDatabaseDelegate databaseDelegate = new JdbcDatabaseDelegate(jdbcContainer, "");
            ScriptUtils.runInitScript((DatabaseDelegate)databaseDelegate, (String)"mysql-test-data-linux.sql");
        }
        HashMap<String, String> sourceParameters = new HashMap<String, String>();
        sourceParameters.put("maximumPoolSize", "1");
        sourceParameters.put("idleTimeout", String.valueOf(TimeUnit.SECONDS.toMillis(5L)));
        sourceParameters.put("keepaliveTime", String.valueOf(TimeUnit.SECONDS.toMillis(5L)));
        sourceParameters.put("maxLifetime", String.valueOf(TimeUnit.SECONDS.toMillis(20L)));
        sourceParameters.put("minimumIdle", "0");
        String jdbcUrl = jdbcContainer.getJdbcUrl();
        logger.debug("JDBC URL: {}", (Object)jdbcUrl);
        JdbcStorageConfig jdbcStorageConfig = new JdbcStorageConfig("com.mysql.cj.jdbc.Driver", jdbcUrl, jdbcContainer.getUsername(), jdbcContainer.getPassword(), false, true, sourceParameters, null, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("mysql", (StoragePluginConfig)jdbcStorageConfig);
        JdbcStorageConfig jdbcStorageConfigNoWrite = new JdbcStorageConfig("com.mysql.cj.jdbc.Driver", jdbcUrl, jdbcContainer.getUsername(), jdbcContainer.getPassword(), false, false, sourceParameters, null, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
        jdbcStorageConfigNoWrite.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("mysql_no_write", (StoragePluginConfig)jdbcStorageConfigNoWrite);
        if (osName.startsWith("linux")) {
            JdbcStorageConfig jdbcCaseSensitiveStorageConfig = new JdbcStorageConfig("com.mysql.cj.jdbc.Driver", jdbcUrl, jdbcContainer.getUsername(), jdbcContainer.getPassword(), true, true, sourceParameters, null, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
            jdbcCaseSensitiveStorageConfig.setEnabled(Boolean.valueOf(true));
            cluster.defineStoragePlugin("mysqlCaseInsensitive", (StoragePluginConfig)jdbcCaseSensitiveStorageConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertValues() throws Exception {
        String tableName = "mysql.`drill_mysql_test`.`test_table`";
        try {
            String query = "CREATE TABLE %s (ID, NAME) AS (VALUES(1,2))";
            QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query, new Object[]{tableName}).run();
            Assert.assertTrue((boolean)insertResults.succeeded());
            String insertQuery = "insert into %s(ID, NAME) VALUES (3,4)";
            this.queryBuilder().sql(insertQuery, new Object[]{tableName}).planMatcher().include(new String[]{"Jdbc\\(sql=\\[INSERT INTO"}).match();
            this.testBuilder().sqlQuery(insertQuery, new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ROWCOUNT"}).baselineValues(new Object[]{1L}).go();
            this.testBuilder().sqlQuery("select * from %s", new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ID", "NAME"}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{3, 4}).go();
        }
        catch (Throwable throwable) {
            this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
            throw throwable;
        }
        this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertSelectValues() throws Exception {
        String tableName = "mysql.`drill_mysql_test`.`test_table`";
        try {
            String query = "CREATE TABLE %s (ID, NAME) AS (VALUES(1,2))";
            QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query, new Object[]{tableName}).run();
            Assert.assertTrue((boolean)insertResults.succeeded());
            String insertQuery = "INSERT INTO %s SELECT * FROM (VALUES(1,2), (3,4))";
            this.queryBuilder().sql(insertQuery, new Object[]{tableName}).planMatcher().include(new String[]{"Jdbc\\(sql=\\[INSERT INTO"}).match();
            this.testBuilder().sqlQuery(insertQuery, new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ROWCOUNT"}).baselineValues(new Object[]{2L}).go();
            this.testBuilder().sqlQuery("select * from %s", new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ID", "NAME"}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{3, 4}).go();
        }
        catch (Throwable throwable) {
            this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
            throw throwable;
        }
        this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertSelectFromJdbcTable() throws Exception {
        String tableName = "mysql.`drill_mysql_test`.`test_table`";
        try {
            String query = "CREATE TABLE %s (ID, NAME) AS (VALUES(1,2), (3,4))";
            QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query, new Object[]{tableName}).run();
            Assert.assertTrue((boolean)insertResults.succeeded());
            String insertQuery = "INSERT INTO %s SELECT * FROM %s";
            this.queryBuilder().sql(insertQuery, new Object[]{tableName, tableName}).planMatcher().include(new String[]{"Jdbc\\(sql=\\[INSERT INTO"}).match();
            this.testBuilder().sqlQuery(insertQuery, new Object[]{tableName, tableName}).unOrdered().baselineColumns(new String[]{"ROWCOUNT"}).baselineValues(new Object[]{2L}).go();
            this.testBuilder().sqlQuery("select * from %s", new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ID", "NAME"}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{3, 4}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{3, 4}).go();
        }
        catch (Throwable throwable) {
            this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
            throw throwable;
        }
        this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertSelectFromNonJdbcTable() throws Exception {
        String tableName = "mysql.`drill_mysql_test`.`test_table`";
        try {
            String query = "CREATE TABLE %s (ID, NAME) AS (VALUES(1,2))";
            QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query, new Object[]{tableName}).run();
            Assert.assertTrue((boolean)insertResults.succeeded());
            String insertQuery = "INSERT INTO %s SELECT n_nationkey, n_regionkey FROM cp.`tpch/nation.parquet` limit 3";
            this.queryBuilder().sql(insertQuery, new Object[]{tableName, tableName}).planMatcher().exclude(new String[]{"Jdbc\\(sql=\\[INSERT INTO"}).match();
            this.testBuilder().sqlQuery(insertQuery, new Object[]{tableName, tableName}).unOrdered().baselineColumns(new String[]{"ROWCOUNT"}).baselineValues(new Object[]{3L}).go();
            this.testBuilder().sqlQuery("select * from %s", new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ID", "NAME"}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{0, 0}).baselineValues(new Object[]{1, 1}).baselineValues(new Object[]{2, 1}).go();
        }
        catch (Throwable throwable) {
            this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
            throw throwable;
        }
        this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
    }

    @AfterClass
    public static void stopMysql() {
        if (jdbcContainer != null) {
            jdbcContainer.stop();
        }
    }
}

