/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.drill.categories.JdbcStorageTest;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.store.enumerable.plan.EnumMockPlugin;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.exec.store.jdbc.TestJdbcPluginWithH2IT;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.h2.tools.RunScript;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={JdbcStorageTest.class})
public class TestJdbcInsertWithH2
extends ClusterTest {
    @BeforeClass
    public static void init() throws Exception {
        TestJdbcInsertWithH2.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        dirTestWatcher.copyResourceToRoot(Paths.get("", new String[0]));
        Class.forName("org.h2.Driver");
        String connString = "jdbc:h2:" + dirTestWatcher.getTmpDir().getCanonicalPath();
        URL scriptFile = TestJdbcPluginWithH2IT.class.getClassLoader().getResource("h2-test-data.sql");
        Assert.assertNotNull((String)"Script for test tables generation 'h2-test-data.sql' cannot be found in test resources", (Object)scriptFile);
        try (Connection connection = DriverManager.getConnection(connString, "root", "root");
             FileReader fileReader = new FileReader(scriptFile.getFile());){
            RunScript.execute((Connection)connection, (Reader)fileReader);
        }
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", "root");
        credentials.put("password", "root");
        PlainCredentialsProvider credentialsProvider = new PlainCredentialsProvider(credentials);
        HashMap<String, Integer> sourceParameters = new HashMap<String, Integer>();
        sourceParameters.put("minimumIdle", 1);
        JdbcStorageConfig jdbcStorageConfig = new JdbcStorageConfig("org.h2.Driver", connString, "root", "root", true, true, sourceParameters, (CredentialsProvider)credentialsProvider, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        JdbcStorageConfig jdbcStorageConfigNoWrite = new JdbcStorageConfig("org.h2.Driver", connString, "root", "root", true, false, sourceParameters, (CredentialsProvider)credentialsProvider, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        jdbcStorageConfigNoWrite.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("h2", (StoragePluginConfig)jdbcStorageConfig);
        cluster.defineStoragePlugin("h2_unwritable", (StoragePluginConfig)jdbcStorageConfigNoWrite);
        EnumMockPlugin.EnumMockStoragePluginConfig config = new EnumMockPlugin.EnumMockStoragePluginConfig();
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("mocked_enum", (StoragePluginConfig)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertValues() throws Exception {
        String tableName = "h2.tmp.drill_h2_test.`test_table`";
        try {
            String query = "CREATE TABLE %s (ID, NAME) AS (VALUES(1,2))";
            QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query, new Object[]{tableName}).run();
            Assert.assertTrue((boolean)insertResults.succeeded());
            String insertQuery = "insert into %s(ID, NAME) VALUES (3,4)";
            this.queryBuilder().sql(insertQuery, new Object[]{tableName}).planMatcher().include(new String[]{"Jdbc\\(sql=\\[INSERT INTO"}).match();
            this.testBuilder().sqlQuery(insertQuery, new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ROWCOUNT"}).baselineValues(new Object[]{1L}).go();
            this.testBuilder().sqlQuery("select * from %s", new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ID", "NAME"}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{3, 4}).go();
        }
        catch (Throwable throwable) {
            this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
            throw throwable;
        }
        this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertSelectValues() throws Exception {
        String tableName = "h2.tmp.drill_h2_test.`test_table`";
        try {
            String query = "CREATE TABLE %s (ID, NAME) AS (VALUES(1,2))";
            QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query, new Object[]{tableName}).run();
            Assert.assertTrue((boolean)insertResults.succeeded());
            String insertQuery = "INSERT INTO %s SELECT * FROM (VALUES(1,2), (3,4))";
            this.queryBuilder().sql(insertQuery, new Object[]{tableName}).planMatcher().include(new String[]{"Jdbc\\(sql=\\[INSERT INTO"}).match();
            this.testBuilder().sqlQuery(insertQuery, new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ROWCOUNT"}).baselineValues(new Object[]{2L}).go();
            this.testBuilder().sqlQuery("select * from %s", new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ID", "NAME"}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{3, 4}).go();
        }
        catch (Throwable throwable) {
            this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
            throw throwable;
        }
        this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertSelectFromJdbcTable() throws Exception {
        String tableName = "h2.tmp.drill_h2_test.`test_table`";
        try {
            String query = "CREATE TABLE %s (ID, NAME) AS (VALUES(1,2), (3,4))";
            QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query, new Object[]{tableName}).run();
            Assert.assertTrue((boolean)insertResults.succeeded());
            String insertQuery = "INSERT INTO %s SELECT * FROM %s";
            this.queryBuilder().sql(insertQuery, new Object[]{tableName, tableName}).planMatcher().include(new String[]{"Jdbc\\(sql=\\[INSERT INTO"}).match();
            this.testBuilder().sqlQuery(insertQuery, new Object[]{tableName, tableName}).unOrdered().baselineColumns(new String[]{"ROWCOUNT"}).baselineValues(new Object[]{2L}).go();
            this.testBuilder().sqlQuery("select * from %s", new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ID", "NAME"}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{3, 4}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{3, 4}).go();
        }
        catch (Throwable throwable) {
            this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
            throw throwable;
        }
        this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertSelectFromNonJdbcTable() throws Exception {
        String tableName = "h2.tmp.drill_h2_test.`test_table`";
        try {
            String query = "CREATE TABLE %s (ID, NAME) AS (VALUES(1,2))";
            QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query, new Object[]{tableName}).run();
            Assert.assertTrue((boolean)insertResults.succeeded());
            String insertQuery = "INSERT INTO %s SELECT n_nationkey, n_regionkey FROM cp.`tpch/nation.parquet` limit 3";
            this.queryBuilder().sql(insertQuery, new Object[]{tableName, tableName}).planMatcher().exclude(new String[]{"Jdbc\\(sql=\\[INSERT INTO"}).match();
            this.testBuilder().sqlQuery(insertQuery, new Object[]{tableName, tableName}).unOrdered().baselineColumns(new String[]{"ROWCOUNT"}).baselineValues(new Object[]{3L}).go();
            this.testBuilder().sqlQuery("select * from %s", new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ID", "NAME"}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{0, 0}).baselineValues(new Object[]{1, 1}).baselineValues(new Object[]{2, 1}).go();
        }
        catch (Throwable throwable) {
            this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
            throw throwable;
        }
        this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
    }
}

