/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;
import org.apache.drill.test.BaseDirTestWatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestDataSource {
    @Rule
    public BaseDirTestWatcher dirTestWatcher = new BaseDirTestWatcher();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final String DRIVER = "org.h2.Driver";
    private String url;

    @Before
    public void init() throws Exception {
        this.url = "jdbc:h2:" + this.dirTestWatcher.getTmpDir().getCanonicalPath();
    }

    @Test
    public void testInitWithoutUserAndPassword() {
        JdbcStorageConfig config = new JdbcStorageConfig(DRIVER, this.url, null, null, false, false, null, null, null, 1000);
        try (HikariDataSource dataSource = JdbcStoragePlugin.initDataSource((JdbcStorageConfig)config, null);){
            Assert.assertEquals((Object)DRIVER, (Object)dataSource.getDriverClassName());
            Assert.assertEquals((Object)this.url, (Object)dataSource.getJdbcUrl());
            Assert.assertNull((Object)dataSource.getUsername());
            Assert.assertNull((Object)dataSource.getPassword());
            Assert.assertEquals((Object)config.getAuthMode(), (Object)StoragePluginConfig.AuthMode.SHARED_USER);
        }
    }

    @Test
    public void testInitWithUserAndPassword() {
        JdbcStorageConfig config = new JdbcStorageConfig(DRIVER, this.url, "user", "password", false, false, null, null, StoragePluginConfig.AuthMode.SHARED_USER.name(), 1000);
        UsernamePasswordCredentials jdbcCreds = (UsernamePasswordCredentials)config.getUsernamePasswordCredentials(null).get();
        try (HikariDataSource dataSource = JdbcStoragePlugin.initDataSource((JdbcStorageConfig)config, (UsernamePasswordCredentials)jdbcCreds);){
            Assert.assertEquals((Object)"user", (Object)dataSource.getUsername());
            Assert.assertEquals((Object)"password", (Object)dataSource.getPassword());
        }
    }

    @Test
    public void testInitWithSourceParameters() {
        HashMap<String, Object> sourceParameters = new HashMap<String, Object>();
        sourceParameters.put("minimumIdle", 5);
        sourceParameters.put("autoCommit", false);
        sourceParameters.put("connectionTestQuery", "select * from information_schema.collations");
        sourceParameters.put("dataSource.cachePrepStmts", true);
        sourceParameters.put("dataSource.prepStmtCacheSize", 250);
        sourceParameters.put("dataSource.minimumIdle", 0);
        JdbcStorageConfig config = new JdbcStorageConfig(DRIVER, this.url, "user", "password", false, false, sourceParameters, null, StoragePluginConfig.AuthMode.SHARED_USER.name(), 1000);
        UsernamePasswordCredentials jdbcCreds = (UsernamePasswordCredentials)config.getUsernamePasswordCredentials(null).get();
        try (HikariDataSource dataSource = JdbcStoragePlugin.initDataSource((JdbcStorageConfig)config, (UsernamePasswordCredentials)jdbcCreds);){
            Assert.assertEquals((long)5L, (long)dataSource.getMinimumIdle());
            Assert.assertFalse((boolean)dataSource.isAutoCommit());
            Assert.assertEquals((Object)"select * from information_schema.collations", (Object)dataSource.getConnectionTestQuery());
            Assert.assertEquals((Object)true, (Object)dataSource.getDataSourceProperties().get("cachePrepStmts"));
            Assert.assertEquals((Object)250, (Object)dataSource.getDataSourceProperties().get("prepStmtCacheSize"));
            Assert.assertEquals((Object)0, (Object)dataSource.getDataSourceProperties().get("minimumIdle"));
        }
    }

    @Test
    public void testInitWithIncorrectSourceParameterName() {
        HashMap<String, String> sourceParameters = new HashMap<String, String>();
        sourceParameters.put("abc", "abc");
        JdbcStorageConfig config = new JdbcStorageConfig(DRIVER, this.url, "user", "password", false, false, sourceParameters, null, StoragePluginConfig.AuthMode.SHARED_USER.name(), 1000);
        UsernamePasswordCredentials jdbcCreds = (UsernamePasswordCredentials)config.getUsernamePasswordCredentials(null).get();
        this.thrown.expect(UserException.class);
        this.thrown.expectMessage(UserBitShared.DrillPBError.ErrorType.CONNECTION.name());
        JdbcStoragePlugin.initDataSource((JdbcStorageConfig)config, (UsernamePasswordCredentials)jdbcCreds);
    }

    @Test
    public void testInitWithIncorrectSourceParameterValue() {
        HashMap<String, String> sourceParameters = new HashMap<String, String>();
        sourceParameters.put("minimumIdle", "abc");
        JdbcStorageConfig config = new JdbcStorageConfig(DRIVER, this.url, "user", "password", false, false, sourceParameters, null, StoragePluginConfig.AuthMode.SHARED_USER.name(), 1000);
        UsernamePasswordCredentials jdbcCreds = (UsernamePasswordCredentials)config.getUsernamePasswordCredentials(null).get();
        this.thrown.expect(UserException.class);
        this.thrown.expectMessage(UserBitShared.DrillPBError.ErrorType.CONNECTION.name());
        JdbcStoragePlugin.initDataSource((JdbcStorageConfig)config, (UsernamePasswordCredentials)jdbcCreds);
    }
}

