/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

public class InsertStatementBuilder {
    private final List<SqlNode> sqlRows = new ArrayList<SqlNode>();
    private final List<SqlNode> sqlRowValues = new ArrayList<SqlNode>();
    private final SqlDialect dialect;
    private final List<String> tableIdentifier;

    public InsertStatementBuilder(List<String> tableIdentifier, SqlDialect dialect) {
        this.dialect = dialect;
        this.tableIdentifier = tableIdentifier;
    }

    public void addRowValue(SqlNode value) {
        this.sqlRowValues.add(value);
    }

    public void endRecord() {
        this.sqlRows.add((SqlNode)SqlInternalOperators.ANONYMOUS_ROW.createCall(SqlParserPos.ZERO, this.sqlRowValues.toArray(new SqlNode[0])));
        this.resetRow();
    }

    public void resetRow() {
        this.sqlRowValues.clear();
    }

    public String buildInsertQuery() {
        SqlCall values = SqlStdOperatorTable.VALUES.createCall(SqlParserPos.ZERO, this.sqlRows.toArray(new SqlNode[0]));
        this.resetRow();
        this.sqlRows.clear();
        SqlInsert sqlInsert = new SqlInsert(SqlParserPos.ZERO, SqlNodeList.EMPTY, (SqlNode)new SqlIdentifier(this.tableIdentifier, SqlParserPos.ZERO), (SqlNode)values, null);
        return sqlInsert.toSqlString(this.dialect).getSql();
    }
}

