/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.adapter.jdbc.JdbcToEnumerableConverterRule;
import org.apache.calcite.linq4j.tree.ConstantUntypedNull;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.sql.SqlDialect;
import org.apache.drill.exec.planner.RuleInstance;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.enumerable.plan.DrillJdbcRuleBase;
import org.apache.drill.exec.store.enumerable.plan.VertexDrelConverterRule;
import org.apache.drill.exec.store.jdbc.JdbcIntermediatePrelConverterRule;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;
import org.apache.drill.exec.store.jdbc.rules.JdbcLimitRule;
import org.apache.drill.exec.store.jdbc.rules.JdbcSortRule;

public class DrillJdbcConvention
extends JdbcConvention {
    private static final Set<Class<? extends RelOptRule>> EXCLUDED_CALCITE_RULES = ImmutableSet.of(JdbcToEnumerableConverterRule.class, JdbcRules.JdbcFilterRule.class, JdbcRules.JdbcProjectRule.class, JdbcRules.JdbcSortRule.class);
    private final ImmutableSet<RelOptRule> rules;
    private final JdbcStoragePlugin plugin;

    DrillJdbcConvention(SqlDialect dialect, String name, JdbcStoragePlugin plugin, UserBitShared.UserCredentials userCredentials) {
        super(dialect, (Expression)ConstantUntypedNull.INSTANCE, name);
        this.plugin = plugin;
        List<RelTrait> inputTraits = Arrays.asList(Convention.NONE, DrillRel.DRILL_LOGICAL);
        ImmutableSet.Builder builder = ImmutableSet.builder().add((Object)new JdbcIntermediatePrelConverterRule(this, userCredentials)).add((Object)VertexDrelConverterRule.create((Convention)this)).add((Object)RuleInstance.FILTER_SET_OP_TRANSPOSE_RULE).add((Object)RuleInstance.PROJECT_REMOVE_RULE);
        for (RelTrait inputTrait : inputTraits) {
            builder.add((Object)new DrillJdbcRuleBase.DrillJdbcProjectRule(inputTrait, (JdbcConvention)this)).add((Object)new DrillJdbcRuleBase.DrillJdbcFilterRule(inputTrait, (JdbcConvention)this)).add((Object)new JdbcSortRule(inputTrait, this)).add((Object)new JdbcLimitRule(inputTrait, this));
            DrillJdbcConvention.rules(inputTrait, this).stream().filter(rule -> !EXCLUDED_CALCITE_RULES.contains(rule.getClass())).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        }
        this.rules = builder.build();
    }

    public void register(RelOptPlanner planner) {
        this.rules.forEach(arg_0 -> ((RelOptPlanner)planner).addRule(arg_0));
    }

    public Set<RelOptRule> getRules() {
        return this.rules;
    }

    public JdbcStoragePlugin getPlugin() {
        return this.plugin;
    }

    private static List<RelOptRule> rules(RelTrait inputTrait, JdbcConvention out) {
        ImmutableList.Builder b = ImmutableList.builder();
        DrillJdbcConvention.foreachRule(out, r -> b.add((Object)((ConverterRule.Config)r.config.as(ConverterRule.Config.class)).withConversion(r.getOperand().getMatchedClass(), inputTrait, (RelTrait)out, r.config.description()).withRelBuilderFactory(DrillRelFactories.LOGICAL_BUILDER).toRule()));
        return b.build();
    }

    private static void foreachRule(JdbcConvention out, Consumer<RelRule<?>> consumer) {
        consumer.accept((RelRule<?>)JdbcToEnumerableConverterRule.create((JdbcConvention)out));
        consumer.accept((RelRule<?>)JdbcRules.JdbcJoinRule.create((JdbcConvention)out));
        consumer.accept((RelRule<?>)JdbcRules.JdbcProjectRule.create((JdbcConvention)out));
        consumer.accept((RelRule<?>)JdbcRules.JdbcFilterRule.create((JdbcConvention)out));
        consumer.accept((RelRule<?>)JdbcRules.JdbcAggregateRule.create((JdbcConvention)out));
        consumer.accept((RelRule<?>)JdbcRules.JdbcSortRule.create((JdbcConvention)out));
        consumer.accept((RelRule<?>)JdbcRules.JdbcUnionRule.create((JdbcConvention)out));
        consumer.accept((RelRule<?>)JdbcRules.JdbcIntersectRule.create((JdbcConvention)out));
        consumer.accept((RelRule<?>)JdbcRules.JdbcMinusRule.create((JdbcConvention)out));
        consumer.accept((RelRule<?>)JdbcRules.JdbcTableModificationRule.create((JdbcConvention)out));
        consumer.accept((RelRule<?>)JdbcRules.JdbcValuesRule.create((JdbcConvention)out));
    }
}

