/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.drill.categories.JdbcStorageTest;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

@Category(value={JdbcStorageTest.class})
public class TestJdbcPluginWithPostgres
extends ClusterTest {
    private static final String DOCKER_IMAGE_POSTGRES_X86 = "postgres:12.8-alpine3.14";
    private static JdbcDatabaseContainer<?> jdbcContainer;

    @BeforeClass
    public static void initPostgres() throws Exception {
        TestJdbcPluginWithPostgres.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        String postgresDBName = "drill_postgres_test";
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        DockerImageName imageName = DockerImageName.parse((String)DOCKER_IMAGE_POSTGRES_X86);
        jdbcContainer = new PostgreSQLContainer(imageName).withUsername("postgres").withPassword("password").withDatabaseName(postgresDBName).withInitScript("postgres-test-data.sql");
        jdbcContainer.start();
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", jdbcContainer.getUsername());
        credentials.put("password", jdbcContainer.getPassword());
        PlainCredentialsProvider credentialsProvider = new PlainCredentialsProvider(credentials);
        JdbcStorageConfig jdbcStorageConfig = new JdbcStorageConfig("org.postgresql.Driver", jdbcContainer.getJdbcUrl(), null, null, true, false, null, (CredentialsProvider)credentialsProvider, StoragePluginConfig.AuthMode.SHARED_USER.name(), 100000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("pg", (StoragePluginConfig)jdbcStorageConfig);
    }

    @AfterClass
    public static void stopPostgres() {
        if (jdbcContainer != null) {
            jdbcContainer.stop();
        }
    }

    @Test
    public void validateResult() throws Exception {
        String sql = "SELECT person_id, first_name, last_name, address, city, state, zip, json, bigint_field, smallint_field, decimal_field, boolean_field, double_field, float_field, date_field, datetime_field, enum_field FROM pg.`public`.person ORDER BY person_id";
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("person_id", TypeProtos.MinorType.INT, 10).addNullable("first_name", TypeProtos.MinorType.VARCHAR, 38).addNullable("last_name", TypeProtos.MinorType.VARCHAR, 38).addNullable("address", TypeProtos.MinorType.VARCHAR, 38).addNullable("city", TypeProtos.MinorType.VARCHAR, 38).addNullable("state", TypeProtos.MinorType.VARCHAR, 2).addNullable("zip", TypeProtos.MinorType.INT, 10).addNullable("json", TypeProtos.MinorType.VARCHAR, 38).addNullable("bigint_field", TypeProtos.MinorType.BIGINT, 19).addNullable("smallint_field", TypeProtos.MinorType.INT, 5).addNullable("decimal_field", TypeProtos.MinorType.FLOAT8, 15, 2).addNullable("boolean_field", TypeProtos.MinorType.BIT, 1).addNullable("double_field", TypeProtos.MinorType.FLOAT8, 17, 17).addNullable("float_field", TypeProtos.MinorType.FLOAT8, 17, 17).addNullable("date_field", TypeProtos.MinorType.DATE, 13, 0).addNullable("datetime_field", TypeProtos.MinorType.TIMESTAMP, 22).addNullable("enum_field", TypeProtos.MinorType.VARCHAR, 38).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{1, "first_name_1", "last_name_1", "1401 John F Kennedy Blvd", "Philadelphia", "PA", 19107, "{ a : 5, b : 6 }", 123456789L, 1, new BigDecimal("123.32"), 0, 1.0, 1.1, LocalDate.parse("2012-02-29"), 1330520401000L, "XXX"}).addRow(new Object[]{2, "first_name_2", "last_name_2", "One Ferry Building", "San Francisco", "CA", 94111, "{ z : [ 1, 2, 3 ] }", 45456767L, 3, null, 1, 3.0, 3.1, LocalDate.parse("2011-10-30"), 1319974461000L, "YYY"}).addRow(new Object[]{3, "first_name_3", "last_name_3", "176 Bowery", "New York", "NY", 10012, "{ [ a, b, c ] }", 123090L, -3, null, 0, 5.0, 5.1, LocalDate.parse("2015-06-01"), 1442936770000L, "ZZZ"}).addRow(new Object[]{5, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void pushDownJoin() throws Exception {
        String query = "select x.person_id from (select person_id from pg.`public`.person) x join (select person_id from pg.`public`.person) y on x.person_id = y.person_id";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Join"}).match();
    }

    @Test
    public void pushDownJoinAndFilterPushDown() throws Exception {
        String query = "select * from pg.`public`.person e INNER JOIN pg.`public`.person s ON e.first_name = s.first_name WHERE e.last_name > 'hello'";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Join", "Filter"}).match();
    }

    @Test
    public void testPhysicalPlanSubmission() throws Exception {
        String query = "select * from pg.`public`.person";
        String plan = this.queryBuilder().sql(query).explainJson();
        Assert.assertEquals((long)4L, (long)this.queryBuilder().physical(plan).run().recordCount());
    }

    @Test
    public void emptyOutput() {
        String query = "select * from pg.`public`.person e limit 0";
        this.testBuilder().sqlQuery(query).expectsEmptyResultSet();
    }

    @Test
    public void testExpressionsWithoutAlias() throws Exception {
        String sql = "select count(*), 1+1+2+3+5+8+13+21+34, (1+sqrt(5))/2\nfrom pg.`public`.person";
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("EXPR$0", TypeProtos.MinorType.BIGINT, 19).addNullable("EXPR$1", TypeProtos.MinorType.INT, 10).addNullable("EXPR$2", TypeProtos.MinorType.FLOAT8, 17, 17).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{4L, 88L, 1.618033988749895}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testExpressionsWithoutAliasesPermutations() throws Exception {
        String query = "select EXPR$1, EXPR$0, EXPR$2\nfrom (select 1+1+2+3+5+8+13+21+34, (1+sqrt(5))/2, count(*) from pg.`public`.person)";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"EXPR$1", "EXPR$0", "EXPR$2"}).baselineValues(new Object[]{1.618033988749895, 88, 4L}).go();
    }

    @Test
    public void testExpressionsWithAliases() throws Exception {
        String query = "SELECT person_id AS ID, 1+1+2+3+5+8+13+21+34 as FIBONACCI_SUM, (1+sqrt(5))/2 as golden_ratio\nFROM pg.`public`.person limit 2";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"ID", "FIBONACCI_SUM", "golden_ratio"}).baselineValues(new Object[]{1, 88, 1.618033988749895}).baselineValues(new Object[]{2, 88, 1.618033988749895}).go();
    }

    @Test
    public void testJoinStar() throws Exception {
        String query = "select * from (select person_id from pg.`public`.person) t1 join (select person_id from pg.`public`.person) t2 on t1.person_id = t2.person_id";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"person_id", "person_id0"}).baselineValues(new Object[]{1, 1}).baselineValues(new Object[]{2, 2}).baselineValues(new Object[]{3, 3}).baselineValues(new Object[]{5, 5}).go();
    }

    @Test
    public void testSemiJoin() throws Exception {
        String query = "select person_id from pg.`public`.person t1\nwhere exists (select person_id from pg.`public`.person\nwhere t1.person_id = person_id)";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"person_id"}).baselineValuesForSingleColumn(new Object[]{1, 2, 3, 5}).go();
    }

    @Test
    public void testInformationSchemaViews() throws Exception {
        String query = "select * from information_schema.`views`";
        TestJdbcPluginWithPostgres.run((String)query, (Object[])new Object[0]);
    }

    @Test
    public void testJdbcTableTypes() throws Exception {
        String query = "select distinct table_type from information_schema.`tables` where table_schema like 'pg%'";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"table_type"}).baselineValuesForSingleColumn(new Object[]{"TABLE", "VIEW", "INDEX", "SEQUENCE", "SYSTEM INDEX", "SYSTEM TABLE", "SYSTEM VIEW"}).go();
    }

    @Test
    public void testLimitPushDown() throws Exception {
        String query = "select person_id, first_name, last_name from pg.`public`.person limit 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*FETCH NEXT 100 ROWS ONLY"}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testLimitPushDownWithOrderBy() throws Exception {
        String query = "select person_id from pg.`public`.person order by first_name limit 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*ORDER BY \"first_name\" FETCH NEXT 100 ROWS ONLY"}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testLimitPushDownWithOffset() throws Exception {
        String query = "select person_id, first_name from pg.`public`.person limit 100 offset 10";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*OFFSET 10 ROWS FETCH NEXT 100 ROWS ONLY"}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testLimitPushDownWithConvertFromJson() throws Exception {
        String query = "select convert_fromJSON(first_name)['ppid'] from pg.`public`.person LIMIT 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*FETCH NEXT 100"}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testAvgFunction() throws Exception {
        String query = "select avg(person_id) `avg` from pg.`public`.person";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"avg"}).baselineValues(new Object[]{2.75}).go();
    }
}

