/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.io.IOException;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.drill.categories.JdbcStorageTest;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.exec.store.jdbc.JdbcTestUtils;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.apache.hadoop.fs.Path;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

@Category(value={JdbcStorageTest.class})
public class TestJdbcWriterWithPostgres
extends ClusterTest {
    private static final String DOCKER_IMAGE_POSTGRES_X86 = "postgres:12.8-alpine3.14";
    private static JdbcDatabaseContainer<?> jdbcContainer;

    @BeforeClass
    public static void initPostgres() throws Exception {
        TestJdbcWriterWithPostgres.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        dirTestWatcher.copyResourceToRoot(Paths.get("", new String[0]));
        String postgresDBName = "drill_postgres_test";
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        DockerImageName imageName = DockerImageName.parse((String)DOCKER_IMAGE_POSTGRES_X86);
        jdbcContainer = new PostgreSQLContainer(imageName).withUsername("postgres").withPassword("password").withDatabaseName(postgresDBName).withInitScript("postgres-test-data.sql");
        jdbcContainer.start();
        HashMap<String, String> sourceParameters = new HashMap<String, String>();
        sourceParameters.put("maximumPoolSize", "16");
        sourceParameters.put("idleTimeout", String.valueOf(TimeUnit.SECONDS.toMillis(5L)));
        sourceParameters.put("keepaliveTime", String.valueOf(TimeUnit.SECONDS.toMillis(5L)));
        sourceParameters.put("maxLifetime", String.valueOf(TimeUnit.SECONDS.toMillis(20L)));
        sourceParameters.put("minimumIdle", "0");
        JdbcStorageConfig jdbcStorageConfig = new JdbcStorageConfig("org.postgresql.Driver", jdbcContainer.getJdbcUrl(), jdbcContainer.getUsername(), jdbcContainer.getPassword(), true, true, sourceParameters, null, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("pg", (StoragePluginConfig)jdbcStorageConfig);
        JdbcStorageConfig unWritableJdbcStorageConfig = new JdbcStorageConfig("org.postgresql.Driver", jdbcContainer.getJdbcUrl(), jdbcContainer.getUsername(), jdbcContainer.getPassword(), true, false, sourceParameters, null, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
        unWritableJdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("pg_unwritable", (StoragePluginConfig)unWritableJdbcStorageConfig);
    }

    @AfterClass
    public static void stopPostgres() {
        if (jdbcContainer != null) {
            jdbcContainer.stop();
        }
    }

    @Test
    public void testUnwritableConnectionWithIfNotExists() throws Exception {
        try {
            String query = "CREATE TABLE IF NOT EXISTS pg_unwritable.public.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
            this.queryBuilder().sql(query).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            System.out.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR: Unable to create or drop objects. Schema [pg_unwritable.public] is immutable."));
        }
    }

    @Test
    public void testUnwritableConnection() throws Exception {
        try {
            String query = "CREATE TABLE pg_unwritable.`public`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
            this.queryBuilder().sql(query).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            System.out.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR: Unable to create or drop objects. Schema [pg_unwritable.public] is immutable."));
        }
    }

    @Test
    public void testBasicCTAS() throws Exception {
        String query = "CREATE TABLE pg.`public`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        String testQuery = "SELECT * FROM pg.`public`.`test_table`";
        DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("ID", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("NAME", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1, 2}).addRow(new Object[]{3, 4}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE pg.`public`.`test_table`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testBasicCTASWithDataTypes() throws Exception {
        String query = "CREATE TABLE pg.public.`data_types` AS SELECT CAST(1 AS INTEGER) AS int_field,CAST(2 AS BIGINT) AS bigint_field,CAST(3.0 AS FLOAT) AS float4_field,CAST(4.0 AS DOUBLE) AS float8_field,'5.0' AS varchar_field,CAST('2021-01-01' AS DATE) as date_field,CAST('12:00:00' AS TIME) as time_field, CAST('2015-12-30 22:55:55.23' AS TIMESTAMP) as timestamp_field, true AS boolean_field FROM (VALUES(1))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        String testQuery = "SELECT * FROM  pg.`public`.`data_types`";
        DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("int_field", TypeProtos.MinorType.INT, 10).addNullable("bigint_field", TypeProtos.MinorType.BIGINT, 19).addNullable("float4_field", TypeProtos.MinorType.FLOAT8, 17, 17).addNullable("float8_field", TypeProtos.MinorType.FLOAT8, 17, 17).addNullable("varchar_field", TypeProtos.MinorType.VARCHAR, 3).addNullable("date_field", TypeProtos.MinorType.DATE, 13).addNullable("time_field", TypeProtos.MinorType.TIME, 12, 3).addNullable("timestamp_field", TypeProtos.MinorType.TIMESTAMP, 26, 3).addNullable("boolean_field", TypeProtos.MinorType.BIT, 1).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1, 2L, 3.0, 4.0, "5.0", LocalDate.parse("2021-01-01"), LocalTime.parse("12:00"), 1451516155230L, true}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE pg.`public`.`data_types`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testBasicCTASWithSpacesInTableName() throws Exception {
        String query = "CREATE TABLE pg.public.`test table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        String testQuery = "SELECT * FROM pg.public.`test table`";
        DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("ID", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("NAME", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1, 2}).addRow(new Object[]{3, 4}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE pg.public.`test table`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testWithLargeFile() throws Exception {
        String query = "CREATE TABLE pg.public.test (id,first_name,last_name,email,gender,ip_address) AS SELECT id,first_name,last_name,email,gender,ip_address FROM cp.`csv/large_csv.csvh`";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        query = "SELECT COUNT(*) FROM pg.public.test";
        long rowCount = this.queryBuilder().sql(query).singletonLong();
        Assert.assertEquals((long)6000L, (long)rowCount);
        String dropQuery = "DROP TABLE pg.public.`test`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    @Ignore(value="This is a slow test.  Please run manually.")
    public void testWithReallyLongFile() throws Exception {
        Path generatedFile = null;
        try {
            generatedFile = JdbcTestUtils.generateCsvFile("csv/very_large_file.csvh", 10, 100000);
        }
        catch (IOException e) {
            Assert.fail();
        }
        String testQuery = "SELECT COUNT(*) FROM dfs.`csv/very_large_file.csvh`";
        long resultsCount = this.queryBuilder().sql(testQuery).singletonLong();
        Assert.assertEquals((long)100000L, (long)resultsCount);
        String ctasQuery = "CREATE TABLE pg.public.`test_big_table` AS SELECT * FROM dfs.`csv/very_large_file.csvh`";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(ctasQuery).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        testQuery = "SELECT COUNT(*) FROM pg.public.`test_big_table`";
        resultsCount = this.queryBuilder().sql(testQuery).singletonLong();
        Assert.assertEquals((long)100000L, (long)resultsCount);
        String dropQuery = "DROP TABLE pg.public.`test_big_table`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
        boolean deletedFile = JdbcTestUtils.deleteCsvFile(String.valueOf(generatedFile));
        if (!deletedFile) {
            Assert.fail();
        }
    }

    @Test
    public void testBasicCTASWithSpacesInFieldNames() throws Exception {
        String query = "CREATE TABLE pg.public.`test table` (`My id`, `My name`) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        String testQuery = "SELECT * FROM pg.public.`test table`";
        DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("My id", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("My name", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1, 2}).addRow(new Object[]{3, 4}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE pg.public.`test table`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testCTASFromFileWithNulls() throws Exception {
        String sql = "CREATE TABLE pg.public.`t1` AS SELECT int_field, float_field, varchar_field, boolean_field FROM cp.`json/dataTypes.json`";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        sql = "SELECT * FROM pg.public.`t1`";
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("int_field", TypeProtos.MinorType.BIGINT, 19).addNullable("float_field", TypeProtos.MinorType.FLOAT8, 22).addNullable("varchar_field", TypeProtos.MinorType.VARCHAR, 38).addNullable("boolean_field", TypeProtos.MinorType.BIT, 1).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 1.0, "foo1", true}).addRow(new Object[]{null, null, null, null}).addRow(new Object[]{2L, 2.0, "foo2", false}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE pg.`public`.`t1`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testDropNonExistentTable() throws Exception {
        String dropQuery = "DROP TABLE pg.`public`.`none_shall_pass`";
        try {
            this.queryBuilder().sql(dropQuery).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR: Table [none_shall_pass] not found"));
        }
    }

    @Test
    public void testBasicCTASIfNotExists() throws Exception {
        String query = "CREATE TABLE IF NOT EXISTS pg.`public`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        String testQuery = "SELECT * FROM  pg.`public`.`test_table`";
        DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("ID", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("NAME", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1, 2}).addRow(new Object[]{3, 4}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE pg.`public`.`test_table`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testCTASWithDuplicateTable() throws Exception {
        String query = "CREATE TABLE pg.`public`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        try {
            this.queryBuilder().sql(query).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR"));
        }
        query = "CREATE TABLE IF NOT EXISTS pg.`public`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        DirectRowSet results = this.queryBuilder().sql(query).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("ok", TypeProtos.MinorType.BIT).add("summary", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{false, "A table or view with given name [test_table] already exists in schema [pg.public]"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testWithComplexData() throws Exception {
        try {
            String sql = "CREATE TABLE pg.`public`.`complex` AS SELECT * FROM cp.`json/complexData.json`";
            this.queryBuilder().sql(sql).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("DATA_WRITE ERROR: Drill does not support writing complex fields to JDBC data sources."));
        }
    }

    @Test
    public void testCTASFromFileWithUglyData() throws Exception {
        String sql = "CREATE TABLE pg.public.`t2` AS SELECT ugly1, ugly2 FROM cp.`json/uglyData.json`";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        sql = "SELECT * FROM  pg.public.`t2`";
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("ugly1", TypeProtos.MinorType.VARCHAR, 38).addNullable("ugly2", TypeProtos.MinorType.VARCHAR, 38).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"O'Malley", "Abraham Lincoln's best speech started with: \"Four score and seven years ago..."}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE  pg.public.`t2`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testWithArrayField() throws Exception {
        try {
            String sql = "CREATE TABLE pg.`public`.`complex` AS SELECT * FROM cp.`json/repeatedData.json`";
            this.queryBuilder().sql(sql).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"DATA_WRITE ERROR: Drill does not yet support writing arrays to JDBC. repeated_field is an array."));
        }
    }
}

