/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.drill.categories.JdbcStorageTest;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.store.enumerable.plan.EnumMockPlugin;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.h2.tools.RunScript;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={JdbcStorageTest.class})
public class TestJdbcPluginWithH2IT
extends ClusterTest {
    private static final String TABLE_PATH = "jdbcmulti/";
    private static final String TABLE_NAME = String.format("%s.`%s`", "dfs", "jdbcmulti/");
    private static TimeZone defaultTimeZone;
    private static URL SCRIPT_FILE;

    @BeforeClass
    public static void init() throws Exception {
        TestJdbcPluginWithH2IT.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        defaultTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        dirTestWatcher.copyResourceToRoot(Paths.get(TABLE_PATH, new String[0]));
        Class.forName("org.h2.Driver");
        String connString = "jdbc:h2:" + dirTestWatcher.getTmpDir().getCanonicalPath();
        Assert.assertNotNull((String)"Script for test tables generation 'h2-test-data.sql' cannot be found in test resources", (Object)SCRIPT_FILE);
        try (Connection connection = DriverManager.getConnection(connString, "root", "root");
             FileReader fileReader = new FileReader(SCRIPT_FILE.getFile());){
            RunScript.execute((Connection)connection, (Reader)fileReader);
        }
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", "root");
        credentials.put("password", "root");
        PlainCredentialsProvider credentialsProvider = new PlainCredentialsProvider(credentials);
        HashMap<String, Object> sourceParameters = new HashMap<String, Object>();
        sourceParameters.put("minimumIdle", 1);
        sourceParameters.put("maximumPoolSize", "1");
        JdbcStorageConfig jdbcStorageConfig = new JdbcStorageConfig("org.h2.Driver", connString, null, null, true, false, sourceParameters, (CredentialsProvider)credentialsProvider, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("h2", (StoragePluginConfig)jdbcStorageConfig);
        cluster.defineStoragePlugin("h2o", (StoragePluginConfig)jdbcStorageConfig);
        EnumMockPlugin.EnumMockStoragePluginConfig config = new EnumMockPlugin.EnumMockStoragePluginConfig();
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("mocked_enum", (StoragePluginConfig)config);
    }

    @AfterClass
    public static void cleanUp() {
        TimeZone.setDefault(defaultTimeZone);
    }

    @Test
    public void testCrossSourceMultiFragmentJoin() throws Exception {
        try {
            client.alterSession("planner.slice_target", (Object)1);
            TestJdbcPluginWithH2IT.run((String)"select x.person_id, y.salary from h2.tmp.drill_h2_test.person x join %s y on x.person_id = y.person_id ", (Object[])new Object[]{TABLE_NAME});
        }
        finally {
            client.resetSession("planner.slice_target");
        }
    }

    @Test
    public void validateResult() throws Exception {
        this.testBuilder().sqlQuery("select person_id, first_name, last_name, address, city, state, zip, json, bigint_field, smallint_field, numeric_field, boolean_field, double_field, float_field, real_field, time_field, timestamp_field, date_field, clob_field from h2.tmp.`drill_h2_test`.person").ordered().baselineColumns(new String[]{"person_id", "first_name", "last_name", "address", "city", "state", "zip", "json", "bigint_field", "smallint_field", "numeric_field", "boolean_field", "double_field", "float_field", "real_field", "time_field", "timestamp_field", "date_field", "clob_field"}).baselineValues(new Object[]{1, "first_name_1", "last_name_1", "1401 John F Kennedy Blvd", "Philadelphia", "PA", 19107, "{ a : 5, b : 6 }", 123456L, 1, 10.01, false, 1.0, Float.valueOf(1.1f), 111.0, DateUtility.parseLocalTime((String)"13:00:01.0"), DateUtility.parseLocalDateTime((String)"2012-02-29 13:00:01.0"), DateUtility.parseLocalDate((String)"2012-02-29"), "some clob data 1"}).baselineValues(new Object[]{2, "first_name_2", "last_name_2", "One Ferry Building", "San Francisco", "CA", 94111, "{ foo : \"abc\" }", 95949L, 2, 20.02, true, 2.0, Float.valueOf(2.1f), 222.0, DateUtility.parseLocalTime((String)"23:59:59.0"), DateUtility.parseLocalDateTime((String)"1999-09-09 23:59:59.0"), DateUtility.parseLocalDate((String)"1999-09-09"), "some more clob data"}).baselineValues(new Object[]{3, "first_name_3", "last_name_3", "176 Bowery", "New York", "NY", 10012, "{ z : [ 1, 2, 3 ] }", 45456L, 3, 30.04, true, 3.0, Float.valueOf(3.1f), 333.0, DateUtility.parseLocalTime((String)"11:34:21.0"), DateUtility.parseLocalDateTime((String)"2011-10-30 11:34:21.0"), DateUtility.parseLocalDate((String)"2011-10-30"), "clobber"}).baselineValues(new Object[]{4, null, null, "2 15th St NW", "Washington", "DC", 20007, "{ z : { a : 1, b : 2, c : 3 } }", -67L, 4, 40.04, false, 4.0, Float.valueOf(4.1f), 444.0, DateUtility.parseLocalTime((String)"16:00:01.0"), DateUtility.parseLocalDateTime((String)"2015-06-01 16:00:01.0"), DateUtility.parseLocalDate((String)"2015-06-01"), "xxx"}).baselineValues(new Object[]{5, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}).go();
    }

    @Test
    public void pushDownJoin() throws Exception {
        String query = "select x.person_id from (select person_id from h2.tmp.drill_h2_test.person) x join (select person_id from h2.tmp.drill_h2_test.person) y on x.person_id = y.person_id ";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Join"}).match();
    }

    @Test
    public void pushDownJoinAndFilterPushDown() throws Exception {
        String query = "select * from \nh2.tmp.drill_h2_test.person e\nINNER JOIN \nh2.tmp.drill_h2_test.person s\nON e.FIRST_NAME = s.FIRST_NAME\nWHERE e.LAST_NAME > 'hello'";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Join"}).exclude(new String[]{"Filter"}).match();
    }

    @Test
    public void pushDownAggregation() throws Exception {
        String query = "select count(*) from h2.tmp.drill_h2_test.person";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Aggregate"}).match();
    }

    @Test
    public void pushDownDoubleJoinAndFilter() throws Exception {
        String query = "select * from \nh2.tmp.drill_h2_test.person e\nINNER JOIN \nh2.tmp.drill_h2_test.person s\nON e.person_ID = s.person_ID\nINNER JOIN \nh2.tmp.drill_h2_test.person ed\nON e.person_ID = ed.person_ID\nWHERE s.first_name > 'abc' and ed.first_name > 'efg'";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Join"}).exclude(new String[]{"Filter"}).match();
    }

    @Test
    @Ignore
    public void twoPluginsPredicatesPushDown() throws Exception {
        String query = "SELECT * FROM h2.tmp.drill_h2_test.person l INNER JOIN h2o.tmp.drill_h2_test.person r ON l.person_id = r.person_id WHERE l.first_name = 'first_name_1' AND r.last_name = 'last_name_1'";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Filter"}).match();
    }

    @Test
    public void showTablesDefaultSchema() throws Exception {
        TestJdbcPluginWithH2IT.run((String)"use h2.tmp.drill_h2_test", (Object[])new Object[0]);
        Assert.assertEquals((long)1L, (long)this.queryBuilder().sql("show tables like 'PERSON'").run().recordCount());
        Assert.assertEquals((long)1L, (long)this.queryBuilder().sql("show tables like 'person'").run().recordCount());
    }

    @Test
    public void describe() throws Exception {
        TestJdbcPluginWithH2IT.run((String)"use h2.tmp.drill_h2_test", (Object[])new Object[0]);
        Assert.assertEquals((long)19L, (long)this.queryBuilder().sql("describe PERSON").run().recordCount());
        Assert.assertEquals((long)19L, (long)this.queryBuilder().sql("describe person").run().recordCount());
    }

    @Test
    public void ensureDrillFunctionsAreNotPushedDown() throws Exception {
        TestJdbcPluginWithH2IT.run((String)"select CONVERT_FROM(JSON, 'JSON') from h2.tmp.drill_h2_test.person where person_ID = 4", (Object[])new Object[0]);
    }

    @Test
    public void pushDownFilter() throws Exception {
        String query = "select * from h2.tmp.drill_h2_test.person where person_ID = 1";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Filter"}).match();
    }

    @Test
    public void testCaseInsensitiveTableNames() throws Exception {
        Assert.assertEquals((long)5L, (long)this.queryBuilder().sql("select * from h2.tmp.drill_h2_test.PeRsOn").run().recordCount());
        Assert.assertEquals((long)5L, (long)this.queryBuilder().sql("select * from h2.tmp.drill_h2_test.PERSON").run().recordCount());
        Assert.assertEquals((long)5L, (long)this.queryBuilder().sql("select * from h2.tmp.drill_h2_test.person").run().recordCount());
    }

    @Test
    public void testJdbcStoragePluginSerDe() throws Exception {
        String query = "select * from h2.tmp.drill_h2_test.PeRsOn";
        String plan = this.queryBuilder().sql(query).explainJson();
        Assert.assertEquals((long)5L, (long)this.queryBuilder().physical(plan).run().recordCount());
    }

    @Test
    public void showTablesForPluginDefaultSchema() throws Exception {
        TestJdbcPluginWithH2IT.run((String)"USE h2", (Object[])new Object[0]);
        String sql = "SHOW TABLES";
        this.testBuilder().sqlQuery(sql).unOrdered().baselineColumns(new String[]{"TABLE_SCHEMA", "TABLE_NAME"}).baselineValues(new Object[]{"h2.tmp.drill_h2_test_1", "PERSON"}).go();
    }

    @Test
    public void showTablesForInformationSchema() throws Exception {
        TestJdbcPluginWithH2IT.run((String)"USE h2.tmp.`INFORMATION_SCHEMA`", (Object[])new Object[0]);
        String sql = "SHOW TABLES";
        this.testBuilder().sqlQuery(sql).unOrdered().expectsNumRecords(35).csvBaselineFile("h2_information_schema_tables.csv").baselineColumns(new String[]{"TABLE_SCHEMA", "TABLE_NAME"}).go();
    }

    @Test
    public void testJdbcTableTypes() throws Exception {
        String query = "select distinct table_type from information_schema.`tables`";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"table_type"}).baselineValuesForSingleColumn(new Object[]{"SYSTEM TABLE", "TABLE", "VIEW", "OTHER"}).go();
    }

    @Test
    public void testJdbcIntermConvRuleConvention() throws Exception {
        String query = "select t1.person_ID from h2.tmp.drill_h2_test.person t1 join mocked_enum.mock_enum_table t2 on t1.person_ID = t2.a";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"mocked_enum"}).match();
    }

    @Test
    public void testSharedUserNoCreds() throws Exception {
        String connString = "jdbc:h2:" + dirTestWatcher.getTmpDir().getCanonicalPath() + "/noauth";
        JdbcStorageConfig cfg = new JdbcStorageConfig("org.h2.Driver", connString, null, null, true, false, null, null, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
        cfg.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("h2_noauth", (StoragePluginConfig)cfg);
        try (Connection connection = DriverManager.getConnection(connString, null, null);
             FileReader fileReader = new FileReader(SCRIPT_FILE.getFile());){
            RunScript.execute((Connection)connection, (Reader)fileReader);
        }
        TestJdbcPluginWithH2IT.run((String)"USE h2_noauth", (Object[])new Object[0]);
        String sql = "SHOW TABLES";
        this.testBuilder().sqlQuery(sql).unOrdered().baselineColumns(new String[]{"TABLE_SCHEMA", "TABLE_NAME"}).baselineValues(new Object[]{"h2_noauth.noauth.drill_h2_test_1", "PERSON"}).go();
    }

    static {
        SCRIPT_FILE = TestJdbcPluginWithH2IT.class.getClassLoader().getResource("h2-test-data.sql");
    }
}

