/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.nio.file.Paths;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.drill.categories.JdbcStorageTest;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

@Category(value={JdbcStorageTest.class})
public class TestJdbcInsertWithPostgres
extends ClusterTest {
    private static final String DOCKER_IMAGE_POSTGRES_X86 = "postgres:12.8-alpine3.14";
    private static JdbcDatabaseContainer<?> jdbcContainer;

    @BeforeClass
    public static void initPostgres() throws Exception {
        TestJdbcInsertWithPostgres.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        dirTestWatcher.copyResourceToRoot(Paths.get("", new String[0]));
        String postgresDBName = "drill_postgres_test";
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        DockerImageName imageName = DockerImageName.parse((String)DOCKER_IMAGE_POSTGRES_X86);
        jdbcContainer = new PostgreSQLContainer(imageName).withUsername("postgres").withPassword("password").withDatabaseName(postgresDBName).withInitScript("postgres-test-data.sql");
        jdbcContainer.start();
        HashMap<String, String> sourceParameters = new HashMap<String, String>();
        sourceParameters.put("maximumPoolSize", "16");
        sourceParameters.put("idleTimeout", String.valueOf(TimeUnit.SECONDS.toMillis(5L)));
        sourceParameters.put("keepaliveTime", String.valueOf(TimeUnit.SECONDS.toMillis(5L)));
        sourceParameters.put("maxLifetime", String.valueOf(TimeUnit.SECONDS.toMillis(20L)));
        sourceParameters.put("minimumIdle", "0");
        JdbcStorageConfig jdbcStorageConfig = new JdbcStorageConfig("org.postgresql.Driver", jdbcContainer.getJdbcUrl(), jdbcContainer.getUsername(), jdbcContainer.getPassword(), true, true, sourceParameters, null, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("pg", (StoragePluginConfig)jdbcStorageConfig);
        JdbcStorageConfig unWritableJdbcStorageConfig = new JdbcStorageConfig("org.postgresql.Driver", jdbcContainer.getJdbcUrl(), jdbcContainer.getUsername(), jdbcContainer.getPassword(), true, false, sourceParameters, null, StoragePluginConfig.AuthMode.SHARED_USER.name(), 10000);
        unWritableJdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("pg_unwritable", (StoragePluginConfig)unWritableJdbcStorageConfig);
    }

    @AfterClass
    public static void stopPostgres() {
        if (jdbcContainer != null) {
            jdbcContainer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertValues() throws Exception {
        String tableName = "`pg`.`public`.`test_table`";
        try {
            String query = "CREATE TABLE %s (ID, NAME) AS (VALUES(1,2))";
            QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query, new Object[]{tableName}).run();
            Assert.assertTrue((boolean)insertResults.succeeded());
            String insertQuery = "insert into %s(ID, NAME) VALUES (3,4)";
            this.queryBuilder().sql(insertQuery, new Object[]{tableName}).planMatcher().include(new String[]{"Jdbc\\(sql=\\[INSERT INTO"}).match();
            this.testBuilder().sqlQuery(insertQuery, new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ROWCOUNT"}).baselineValues(new Object[]{1L}).go();
            this.testBuilder().sqlQuery("select * from %s", new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ID", "NAME"}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{3, 4}).go();
        }
        catch (Throwable throwable) {
            this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
            throw throwable;
        }
        this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertSelectValues() throws Exception {
        String tableName = "`pg`.`public`.`test_table`";
        try {
            String query = "CREATE TABLE %s (ID, NAME) AS (VALUES(1,2))";
            QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query, new Object[]{tableName}).run();
            Assert.assertTrue((boolean)insertResults.succeeded());
            String insertQuery = "INSERT INTO %s SELECT * FROM (VALUES(1,2), (3,4))";
            this.queryBuilder().sql(insertQuery, new Object[]{tableName}).planMatcher().include(new String[]{"Jdbc\\(sql=\\[INSERT INTO"}).match();
            this.testBuilder().sqlQuery(insertQuery, new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ROWCOUNT"}).baselineValues(new Object[]{2L}).go();
            this.testBuilder().sqlQuery("select * from %s", new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ID", "NAME"}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{3, 4}).go();
        }
        catch (Throwable throwable) {
            this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
            throw throwable;
        }
        this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertSelectFromJdbcTable() throws Exception {
        String tableName = "`pg`.`public`.`test_table`";
        try {
            String query = "CREATE TABLE %s (ID, NAME) AS (VALUES(1,2), (3,4))";
            QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query, new Object[]{tableName}).run();
            Assert.assertTrue((boolean)insertResults.succeeded());
            String insertQuery = "INSERT INTO %s SELECT * FROM %s";
            this.queryBuilder().sql(insertQuery, new Object[]{tableName, tableName}).planMatcher().include(new String[]{"Jdbc\\(sql=\\[INSERT INTO"}).match();
            this.testBuilder().sqlQuery(insertQuery, new Object[]{tableName, tableName}).unOrdered().baselineColumns(new String[]{"ROWCOUNT"}).baselineValues(new Object[]{2L}).go();
            this.testBuilder().sqlQuery("select * from %s", new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ID", "NAME"}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{3, 4}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{3, 4}).go();
        }
        catch (Throwable throwable) {
            this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
            throw throwable;
        }
        this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertSelectFromNonJdbcTable() throws Exception {
        String tableName = "`pg`.`public`.`test_table`";
        try {
            String query = "CREATE TABLE %s (ID, NAME) AS (VALUES(1,2))";
            QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query, new Object[]{tableName}).run();
            Assert.assertTrue((boolean)insertResults.succeeded());
            String insertQuery = "INSERT INTO %s SELECT n_nationkey, n_regionkey FROM cp.`tpch/nation.parquet` limit 3";
            this.queryBuilder().sql(insertQuery, new Object[]{tableName, tableName}).planMatcher().exclude(new String[]{"Jdbc\\(sql=\\[INSERT INTO"}).match();
            this.testBuilder().sqlQuery(insertQuery, new Object[]{tableName, tableName}).unOrdered().baselineColumns(new String[]{"ROWCOUNT"}).baselineValues(new Object[]{3L}).go();
            this.testBuilder().sqlQuery("select * from %s", new Object[]{tableName}).unOrdered().baselineColumns(new String[]{"ID", "NAME"}).baselineValues(new Object[]{1, 2}).baselineValues(new Object[]{0, 0}).baselineValues(new Object[]{1, 1}).baselineValues(new Object[]{2, 1}).go();
        }
        catch (Throwable throwable) {
            this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
            throw throwable;
        }
        this.queryBuilder().sql("DROP TABLE IF EXISTS %s", new Object[]{tableName}).run();
    }
}

