/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc.clickhouse;

import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlDialect;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.SubsetRemover;
import org.apache.drill.exec.store.jdbc.JdbcDialect;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;
import org.apache.drill.exec.store.jdbc.clickhouse.ClickhouseCatalogSchema;
import org.apache.drill.exec.store.jdbc.clickhouse.ClickhouseJdbcImplementor;

public class ClickhouseJdbcDialect
implements JdbcDialect {
    private final JdbcStoragePlugin plugin;

    public ClickhouseJdbcDialect(JdbcStoragePlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void registerSchemas(SchemaConfig config, SchemaPlus parent) {
        ClickhouseCatalogSchema schema = new ClickhouseCatalogSchema(this.plugin.getName(), this.plugin.getDataSource(), this.plugin.getDialect(), this.plugin.getConvention());
        SchemaPlus holder = parent.add(this.plugin.getName(), (Schema)schema);
        schema.setHolder(holder);
    }

    @Override
    public String generateSql(RelOptCluster cluster, RelNode input) {
        SqlDialect dialect = this.plugin.getDialect();
        ClickhouseJdbcImplementor jdbcImplementor = new ClickhouseJdbcImplementor(dialect, (JavaTypeFactory)cluster.getTypeFactory());
        SqlImplementor.Result result = jdbcImplementor.visitChild(0, input.accept(SubsetRemover.INSTANCE));
        return result.asStatement().toSqlString(dialect).getSql();
    }
}

